/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.gelf.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public class GelfMessage {
    public static final String FACILITY = "facility";
    private static final String VERSION_VALUE = "1.1";
    private static final String HOST = "host";
    private static final String SHORT_MESSAGE = "short_message";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private long timestampMillis;
    private Map<String, Object> fieldNameToValueMap = new HashMap<String, Object>();

    public GelfMessage() {
        this.fieldNameToValueMap.put("version", VERSION_VALUE);
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public GelfMessage setTimestampMillis(long timestampMillis) {
        this.timestampMillis = timestampMillis;
        this.fieldNameToValueMap.put("timestamp", (double)timestampMillis / 1000.0);
        return this;
    }

    public String getHost() {
        return (String)this.fieldNameToValueMap.get(HOST);
    }

    public GelfMessage setHost(String host) {
        this.fieldNameToValueMap.put(HOST, host);
        return this;
    }

    public GelfMessage setLevel(int level) {
        this.fieldNameToValueMap.put("level", level);
        return this;
    }

    private String prefix(String name) {
        return '_' + name;
    }

    public GelfMessage setFacility(String facility) {
        this.fieldNameToValueMap.put(this.prefix(FACILITY), facility);
        return this;
    }

    public GelfMessage setFile(String file) {
        this.fieldNameToValueMap.put("_file", file);
        return this;
    }

    public GelfMessage setLine(int line) {
        this.fieldNameToValueMap.put("_line", line);
        return this;
    }

    public GelfMessage setLogger(String logger) {
        this.fieldNameToValueMap.put("_logger", logger);
        return this;
    }

    public GelfMessage setMarker(String marker) {
        this.fieldNameToValueMap.put("_marker", marker);
        return this;
    }

    public GelfMessage setThread(String thread) {
        this.fieldNameToValueMap.put("_thread", thread);
        return this;
    }

    public GelfMessage setShortMessage(String shortMessage) {
        this.fieldNameToValueMap.put(SHORT_MESSAGE, shortMessage);
        return this;
    }

    public GelfMessage setFullMessage(String fullMessage) {
        this.fieldNameToValueMap.put("full_message", fullMessage);
        return this;
    }

    public Object getField(String name) {
        return this.fieldNameToValueMap.get(this.prefix(name));
    }

    public GelfMessage addField(String name, Object value) {
        if (!"id".equals(name)) {
            this.fieldNameToValueMap.put('_' + name, value);
        }
        return this;
    }

    private boolean isNotBlank(String fieldName) {
        Object value = this.fieldNameToValueMap.get(fieldName);
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return !((String)value).trim().isEmpty();
        }
        return false;
    }

    public boolean isValid() {
        return this.isNotBlank(HOST) && this.isNotBlank(SHORT_MESSAGE);
    }

    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.fieldNameToValueMap);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot write JSON", e);
        }
    }
}

