/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigConvert$;
import pureconfig.ConfigReader;
import pureconfig.ConfigWriter;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            public final ConfigReader reader$1;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$1).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.reader$1 = reader$1;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            public final String namespace$2;
            public final ConfigReader reader$4;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.2 $outer;

                    public final Config apply(Config x$1) {
                        return x$1.getConfig(this.$outer.namespace$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.2 $outer;

                    public final Product apply(Config rawConfig) {
                        return ConfigConvert$.MODULE$.improveFailures(package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$4), this.$outer.namespace$2, ConfigValueLocation$.MODULE$.apply((ConfigValue)rawConfig.root())).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.namespace$2 = namespace$2;
                this.reader$4 = reader$4;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$2;
            public final ConfigReader reader$3;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$2).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.3 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$3).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$2 = path$2;
                this.reader$3 = reader$3;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, namespace, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            public final String namespace$1;
            public final ConfigReader reader$2;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$1).right().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.4 $outer;

                    public final Config apply(Config x$2) {
                        return x$2.getConfig(this.$outer.namespace$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.4 $outer;

                    public final Product apply(Config rawConfig) {
                        return ConfigConvert$.MODULE$.improveFailures(package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$2), this.$outer.namespace$1, ConfigValueLocation$.MODULE$.apply((ConfigValue)rawConfig.root())).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$1 = path$1;
                this.namespace$1 = namespace$1;
                this.reader$2 = reader$2;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, ConfigReader<Config> reader) {
        return reader.from((ConfigValue)conf.root());
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, ConfigReader<Config> reader) {
        ConfigObject cv = conf.getConfig(namespace).root();
        return ConfigConvert$.MODULE$.improveFailures(reader.from((ConfigValue)cv), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)cv));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$1;
            public final ConfigReader reader$5;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$1.withFallback((ConfigMergeable)rawConfig), this.$outer.reader$5).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.reader$5 = reader$5;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$2;
            public final String namespace$3;
            public final ConfigReader reader$6;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.2 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$2.withFallback((ConfigMergeable)rawConfig), this.$outer.namespace$3, this.$outer.reader$6).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
                this.namespace$3 = namespace$3;
                this.reader$6 = reader$6;
            }
        });
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (either instanceof Right) {
            Object config;
            Right right = (Right)either;
            Object object = config = right.b();
            return (Config)object;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigReaderFailures failures = (ConfigReaderFailures)left.a();
            throw new ConfigReaderException<Config>(failures, ct);
        }
        throw new MatchError(either);
    }

    public <Config> Config loadConfigOrThrow(ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), ct);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(reader.from((ConfigValue)conf.root()), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        ConfigObject cv = conf.getConfig(namespace).root();
        return this.getResultOrThrow(ConfigConvert$.MODULE$.improveFailures(reader.from((ConfigValue)cv), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)cv)), ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        Either errorOrConfig = ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$3;
            public final ConfigReader reader$7;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$3.withFallback((ConfigMergeable)rawConfig), this.$outer.reader$7).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$3 = conf$3;
                this.reader$7 = reader$7;
            }
        });
        return this.getResultOrThrow(errorOrConfig, ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        Either errorOrConfig = ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$4;
            public final String namespace$4;
            public final ConfigReader reader$8;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$4.withFallback((ConfigMergeable)rawConfig), this.$outer.namespace$4, this.$outer.reader$8).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$4 = conf$4;
                this.namespace$4 = namespace$4;
                this.reader$8 = reader$8;
            }
        });
        return this.getResultOrThrow(errorOrConfig, ct);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigWriter<Config> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists and is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigWriter<Config> writer) {
        PrintStream printOutputStream = new PrintStream(outputStream);
        ConfigValue rawConf = writer.to(conf);
        printOutputStream.print(rawConf.render());
        printOutputStream.close();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, ConfigReader<Config> evidence$1) {
        return files.isEmpty() ? (Either)ConfigConvert$.MODULE$.failWithThrowable(new IllegalArgumentException("The config files to load must not be empty.")).apply((Object)None$.MODULE$) : ((Either)((TraversableOnce)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Path path) {
                return ConfigFactoryWrapper$.MODULE$.parseFile(path);
            }
        }, Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Seq<Config>> apply(Either<ConfigReaderFailures, Seq<Config>> x0$1, Either<ConfigReaderFailures, Config> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Either c1 = (Either)tuple2._1();
                    Either c2 = (Either)tuple2._2();
                    Either<ConfigReaderFailures, C> either = ConfigConvert$.MODULE$.combineResults(c1, c2, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Config> apply(Seq<Config> x$3, Config x$4) {
                            return (Seq)x$3.$colon$plus((Object)x$4, Seq$.MODULE$.canBuildFrom());
                        }
                    });
                    return either;
                }
                throw new MatchError((Object)tuple2);
            }
        })).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Seq<Config> x$5) {
                return ((Config)x$5.reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Config apply(Config x$6, Config x$7) {
                        return x$6.withFallback((ConfigMergeable)x$7);
                    }
                })).resolve();
            }
        }).right().flatMap((Function1)new Serializable(evidence$1){
            public static final long serialVersionUID = 0L;
            private final ConfigReader evidence$1$1;

            public final Either<ConfigReaderFailures, Config> apply(Config conf) {
                return package$.MODULE$.loadConfig(conf, this.evidence$1$1);
            }
            {
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ConfigReader<Config> evidence$2, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, evidence$2), ct);
    }

    private package$() {
        MODULE$ = this;
    }
}

