/*
 * Decompiled with CFR 0.152.
 */
package pureconfig.backend;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import pureconfig.error.CannotParse;
import pureconfig.error.CannotReadFile;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigReaderFailures$;
import pureconfig.error.ConfigValueLocation;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.ThrowableFailure;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class ConfigFactoryWrapper$ {
    public static final ConfigFactoryWrapper$ MODULE$;

    static {
        new ConfigFactoryWrapper$();
    }

    public Either<ConfigReaderFailures, BoxedUnit> invalidateCaches() {
        return this.pureconfig$backend$ConfigFactoryWrapper$$unsafeToEither((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ConfigFactory.invalidateCaches();
            }
        });
    }

    public Either<ConfigReaderFailures, Config> load() {
        return this.pureconfig$backend$ConfigFactoryWrapper$$unsafeToEither((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply() {
                return ConfigFactory.load();
            }
        });
    }

    public Either<ConfigReaderFailures, Config> parseFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) ? this.pureconfig$backend$ConfigFactoryWrapper$$unsafeToEither((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final Config apply() {
                return ConfigFactory.parseFile((File)this.path$1.toFile());
            }
            {
                this.path$1 = path$1;
            }
        }) : package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new CannotReadFile(path)));
    }

    public Either<ConfigReaderFailures, Config> loadFile(Path path) {
        return this.parseFile(path).right().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Config rawConfig) {
                return ConfigFactoryWrapper$.MODULE$.pureconfig$backend$ConfigFactoryWrapper$$unsafeToEither(new Serializable(this, rawConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config rawConfig$1;

                    public final Config apply() {
                        return ConfigFactory.load((Config)this.rawConfig$1);
                    }
                    {
                        this.rawConfig$1 = rawConfig$1;
                    }
                });
            }
        });
    }

    public <A> Either<ConfigReaderFailures, A> pureconfig$backend$ConfigFactoryWrapper$$unsafeToEither(Function0<A> f) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(f.apply());
        }
        catch (Throwable throwable) {
            Left left;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ConfigException.Parse) {
                ConfigException.Parse parse = (ConfigException.Parse)throwable2;
                left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new CannotParse(parse.getLocalizedMessage(), ConfigValueLocation$.MODULE$.apply(parse.origin()))));
            } else if (throwable2 instanceof ConfigException) {
                ConfigException configException = (ConfigException)throwable2;
                left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new ThrowableFailure((Throwable)configException, ConfigValueLocation$.MODULE$.apply(configException.origin()), "")));
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new ThrowableFailure(e, (Option<ConfigValueLocation>)None$.MODULE$, "")));
            }
            right = left;
        }
        return right;
    }

    private ConfigFactoryWrapper$() {
        MODULE$ = this;
    }
}

