/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigConvert$;
import pureconfig.ConfigReader;
import pureconfig.ConfigWriter;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigReaderFailures$;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.KeyNotFound;
import pureconfig.package$;
import pureconfig.package$$anonfun$loadConfig$2$;
import pureconfig.package$$anonfun$loadConfig$4$;
import pureconfig.package$$anonfun$loadConfigWithFallback$2$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            public final ConfigReader reader$1;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$1).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.reader$1 = reader$1;
            }
        });
    }

    public Either<ConfigReaderFailures, Config> pureconfig$package$$getConfigSafe(Config conf, String namespace) {
        Right right;
        try {
            right = scala.package$.MODULE$.Right().apply((Object)conf.getConfig(namespace));
        }
        catch (ConfigException.Missing missing) {
            right = scala.package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new KeyNotFound(namespace, ConfigValueLocation$.MODULE$.apply(missing.origin()), (Set<String>)Predef$.MODULE$.Set().empty())));
        }
        return right;
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            public final String namespace$3;
            public final ConfigReader reader$5;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.2 $outer;

                    public final Either<ConfigReaderFailures, Config> apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$getConfigSafe(rawConfig, this.$outer.namespace$3).right().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$loadConfig$2$$anonfun$apply$3 $outer;

                            public final Product apply(Config scopedConfig) {
                                return ConfigConvert$.MODULE$.improveFailures(package$.MODULE$.loadConfig(scopedConfig, this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().reader$5), this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().namespace$3, ConfigValueLocation$.MODULE$.apply((ConfigValue)scopedConfig.root())).right().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Config apply(Config config) {
                                        return config;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.loadConfig.2 pureconfig$package$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.namespace$3 = namespace$3;
                this.reader$5 = reader$5;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$2;
            public final ConfigReader reader$4;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$2).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.3 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(rawConfig, this.$outer.reader$4).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$2 = path$2;
                this.reader$4 = reader$4;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, namespace, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            public final String namespace$2;
            public final ConfigReader reader$3;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$1).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.4 $outer;

                    public final Either<ConfigReaderFailures, Config> apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$getConfigSafe(rawConfig, this.$outer.namespace$2).right().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$loadConfig$4$$anonfun$apply$8 $outer;

                            public final Product apply(Config scopedConfig) {
                                return ConfigConvert$.MODULE$.improveFailures(package$.MODULE$.loadConfig(scopedConfig, this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().reader$3), this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().namespace$2, ConfigValueLocation$.MODULE$.apply((ConfigValue)scopedConfig.root())).right().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Config apply(Config config) {
                                        return config;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.loadConfig.4 pureconfig$package$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$1 = path$1;
                this.namespace$2 = namespace$2;
                this.reader$3 = reader$3;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, ConfigReader<Config> reader) {
        return reader.from((ConfigValue)conf.root());
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, ConfigReader<Config> reader) {
        return this.pureconfig$package$$getConfigSafe(conf, namespace).right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            private final String namespace$1;
            private final ConfigReader reader$2;

            public final Either<ConfigReaderFailures, Config> apply(Config scopedConfig) {
                return ConfigConvert$.MODULE$.improveFailures(this.reader$2.from((ConfigValue)scopedConfig.root()), this.namespace$1, ConfigValueLocation$.MODULE$.apply((ConfigValue)scopedConfig.root()));
            }
            {
                this.namespace$1 = namespace$1;
                this.reader$2 = reader$2;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$1;
            public final ConfigReader reader$6;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$1.withFallback((ConfigMergeable)rawConfig), this.$outer.reader$6).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.reader$6 = reader$6;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$2;
            public final String namespace$4;
            public final ConfigReader reader$7;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.2 $outer;

                    public final Either<ConfigReaderFailures, Config> apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$getConfigSafe(rawConfig, this.$outer.namespace$4).right().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$loadConfigWithFallback$2$$anonfun$apply$13 $outer;

                            public final Product apply(Config scopedConfig) {
                                return package$.MODULE$.loadConfig(this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().conf$2.withFallback((ConfigMergeable)scopedConfig), this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().namespace$4, this.$outer.pureconfig$package$$anonfun$$anonfun$$$outer().reader$7).right().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Config apply(Config config) {
                                        return config;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.loadConfigWithFallback.2 pureconfig$package$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
                this.namespace$4 = namespace$4;
                this.reader$7 = reader$7;
            }
        });
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (either instanceof Right) {
            Object config;
            Right right = (Right)either;
            Object object = config = right.b();
            return (Config)object;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigReaderFailures failures = (ConfigReaderFailures)left.a();
            throw new ConfigReaderException<Config>(failures, ct);
        }
        throw new MatchError(either);
    }

    public <Config> Config loadConfigOrThrow(ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), ct);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, namespace, reader), ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, reader), ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, namespace, reader), ct);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigWriter<Config> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists and is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigWriter<Config> writer) {
        PrintStream printOutputStream = new PrintStream(outputStream);
        ConfigValue rawConf = writer.to(conf);
        printOutputStream.print(rawConf.render());
        printOutputStream.close();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, ConfigReader<Config> evidence$1) {
        return files.isEmpty() ? (Either)ConfigConvert$.MODULE$.failWithThrowable(new IllegalArgumentException("The config files to load must not be empty.")).apply((Object)None$.MODULE$) : ((Either)((TraversableOnce)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Path path) {
                return ConfigFactoryWrapper$.MODULE$.parseFile(path);
            }
        }, Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Seq<Config>> apply(Either<ConfigReaderFailures, Seq<Config>> x0$1, Either<ConfigReaderFailures, Config> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Either c1 = (Either)tuple2._1();
                    Either c2 = (Either)tuple2._2();
                    Either<ConfigReaderFailures, C> either = ConfigConvert$.MODULE$.combineResults(c1, c2, new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Config> apply(Seq<Config> x$1, Config x$2) {
                            return (Seq)x$1.$colon$plus((Object)x$2, Seq$.MODULE$.canBuildFrom());
                        }
                    });
                    return either;
                }
                throw new MatchError((Object)tuple2);
            }
        })).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Seq<Config> x$3) {
                return ((Config)x$3.reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Config apply(Config x$4, Config x$5) {
                        return x$4.withFallback((ConfigMergeable)x$5);
                    }
                })).resolve();
            }
        }).right().flatMap((Function1)new Serializable(evidence$1){
            public static final long serialVersionUID = 0L;
            private final ConfigReader evidence$1$1;

            public final Either<ConfigReaderFailures, Config> apply(Config conf) {
                return package$.MODULE$.loadConfig(conf, this.evidence$1$1);
            }
            {
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ConfigReader<Config> evidence$2, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, evidence$2), ct);
    }

    private package$() {
        MODULE$ = this;
    }
}

