/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.AllowMissingKey;
import pureconfig.ConfigConvert$;
import pureconfig.ConfigReader;
import pureconfig.ConfigWriter;
import pureconfig.ConvertHelpers$;
import pureconfig.Derivation;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.backend.PathUtil$;
import pureconfig.error.CannotReadFile;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailure;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.KeyNotFound;
import pureconfig.error.ThrowableFailure;
import pureconfig.error.WrongType;
import pureconfig.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    private Either<ConfigReaderFailures, ConfigValue> getValue(Config conf, String namespace, boolean allowNullLeaf) {
        Either either;
        try {
            either = this.getValue$1((ConfigValue)conf.root(), PathUtil$.MODULE$.splitPath(namespace), (List)Nil$.MODULE$, allowNullLeaf);
        }
        catch (ConfigException configException) {
            either = ConvertHelpers$.MODULE$.fail(new ThrowableFailure(configException, ConfigValueLocation$.MODULE$.apply(configException.origin()), ""));
        }
        return either;
    }

    public <A> Either<ConfigReaderFailures, A> pureconfig$package$$loadValue(Config conf, String namespace, Derivation<ConfigReader<A>> reader) {
        return this.getValue(conf, namespace, reader.value() instanceof AllowMissingKey).right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            private final Config conf$1;
            private final String namespace$1;
            private final Derivation reader$1;

            public final Either<ConfigReaderFailures, A> apply(ConfigValue cv) {
                return this.namespace$1.isEmpty() ? ((ConfigReader)this.reader$1.value()).from(cv) : ConfigConvert$.MODULE$.improveFailures(((ConfigReader)this.reader$1.value()).from(cv), this.namespace$1, ConfigValueLocation$.MODULE$.apply((ConfigValue)this.conf$1.root()));
            }
            {
                this.conf$1 = conf$1;
                this.namespace$1 = namespace$1;
                this.reader$1 = reader$1;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig("", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(namespace, reader){
            public static final long serialVersionUID = 0L;
            public final String namespace$3;
            public final Derivation reader$3;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$loadValue(rawConfig, this.$outer.namespace$3, this.$outer.reader$3).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.namespace$3 = namespace$3;
                this.reader$3 = reader$3;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig(path, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(path, namespace, reader){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            public final String namespace$2;
            public final Derivation reader$2;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.loadFile(this.path$1).right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfig.2 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.pureconfig$package$$loadValue(rawConfig, this.$outer.namespace$2, this.$outer.reader$2).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.path$1 = path$1;
                this.namespace$2 = namespace$2;
                this.reader$2 = reader$2;
            }
        });
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.pureconfig$package$$loadValue(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return this.pureconfig$package$$loadValue(conf, namespace, reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfigWithFallback(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1)new Serializable(conf, namespace, reader){
            public static final long serialVersionUID = 0L;
            public final Config conf$2;
            public final String namespace$4;
            public final Derivation reader$4;

            public final Either<ConfigReaderFailures, Config> apply(BoxedUnit _) {
                return ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadConfigWithFallback.1 $outer;

                    public final Product apply(Config rawConfig) {
                        return package$.MODULE$.loadConfig(this.$outer.conf$2.withFallback((ConfigMergeable)rawConfig), this.$outer.namespace$4, this.$outer.reader$4).right().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(Config config) {
                                return config;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$2 = conf$2;
                this.namespace$4 = namespace$4;
                this.reader$4 = reader$4;
            }
        });
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (either instanceof Right) {
            Object config;
            Right right = (Right)either;
            Object object = config = right.b();
            return (Config)object;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            ConfigReaderFailures failures = (ConfigReaderFailures)left.a();
            throw new ConfigReaderException<Config>(failures, ct);
        }
        throw new MatchError(either);
    }

    public <Config> Config loadConfigOrThrow(ClassTag<Config> evidence$1, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), evidence$1);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ClassTag<Config> evidence$2, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), evidence$2);
    }

    public <Config> Config loadConfigOrThrow(Path path, ClassTag<Config> evidence$3, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), evidence$3);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ClassTag<Config> evidence$4, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), evidence$4);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ClassTag<Config> evidence$5, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, reader), evidence$5);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ClassTag<Config> evidence$6, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, namespace, reader), evidence$6);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ClassTag<Config> evidence$7, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, reader), evidence$7);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ClassTag<Config> evidence$8, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, namespace, reader), evidence$8);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, Derivation<ConfigWriter<Config>> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists and is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, Derivation<ConfigWriter<Config>> writer) {
        PrintStream printOutputStream = new PrintStream(outputStream);
        ConfigValue rawConf = writer.value().to(conf);
        printOutputStream.print(rawConf.render());
        printOutputStream.close();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, Derivation<ConfigReader<Config>> reader) {
        return files.isEmpty() ? (Either)ConfigConvert$.MODULE$.failWithThrowable(new IllegalArgumentException("The config files to load must not be empty.")).apply((Object)None$.MODULE$) : ((Either)((TraversableOnce)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Config> apply(Path path) {
                return ConfigFactoryWrapper$.MODULE$.parseFile(path);
            }
        }, Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ConfigReaderFailures, Seq<Config>> apply(Either<ConfigReaderFailures, Seq<Config>> x0$1, Either<ConfigReaderFailures, Config> x1$1) {
                Tuple2 tuple2;
                block4: {
                    Either either;
                    block3: {
                        block2: {
                            Left left;
                            ConfigReaderFailures failures;
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            Either c1 = (Either)tuple2._1();
                            Either either2 = (Either)tuple2._2();
                            if (!(either2 instanceof Left) || !(failures = (ConfigReaderFailures)(left = (Left)either2).a()).toList().exists((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(ConfigReaderFailure x$3) {
                                    return x$3 instanceof CannotReadFile;
                                }
                            })) break block2;
                            either = c1;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Either c1 = (Either)tuple2._1();
                        Either c2 = (Either)tuple2._2();
                        either = ConfigConvert$.MODULE$.combineResults(c1, c2, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Config> apply(Seq<Config> x$4, Config x$5) {
                                return (Seq)x$4.$colon$plus((Object)x$5, Seq$.MODULE$.canBuildFrom());
                            }
                        });
                    }
                    return either;
                }
                throw new MatchError((Object)tuple2);
            }
        })).right().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Config apply(Seq<Config> x$6) {
                return ((Config)x$6.reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Config apply(Config x$7, Config x$8) {
                        return x$7.withFallback((ConfigMergeable)x$8);
                    }
                })).resolve();
            }
        }).right().flatMap((Function1)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final Derivation reader$5;

            public final Either<ConfigReaderFailures, Config> apply(Config conf) {
                return package$.MODULE$.loadConfig(conf, this.reader$5);
            }
            {
                this.reader$5 = reader$5;
            }
        });
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ClassTag<Config> evidence$9, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, reader), evidence$9);
    }

    private final Either getValue$1(ConfigValue cv, List path, List curr, boolean allowNullLeaf$1) {
        Either either;
        block3: {
            while (true) {
                List list;
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)cv, (Object)path)) != null && Nil$.MODULE$.equals(list = (List)tuple2._2())) {
                    either = scala.package$.MODULE$.Right().apply((Object)cv);
                    break block3;
                }
                if (tuple2 == null) break;
                ConfigValue co = (ConfigValue)tuple2._1();
                List list2 = (List)tuple2._2();
                if (!(co instanceof ConfigObject)) break;
                ConfigObject configObject = (ConfigObject)co;
                if (!(list2 instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list2;
                String key = (String)colon2.head();
                List remaining = colon2.tl$1();
                ConfigValue configValue = configObject.get((Object)key);
                if (configValue == null && (remaining.nonEmpty() || !allowNullLeaf$1)) {
                    String string = key;
                    Either either2 = ConvertHelpers$.MODULE$.fail(new KeyNotFound(PathUtil$.MODULE$.joinPath((List<String>)curr.$colon$colon((Object)string).reverse()), ConfigValueLocation$.MODULE$.apply(cv.origin()), (Set<String>)Predef$.MODULE$.Set().empty()));
                    either = either2;
                    break block3;
                }
                String string = key;
                curr = curr.$colon$colon((Object)string);
                path = remaining;
                cv = configValue;
            }
            either = ConvertHelpers$.MODULE$.fail(new WrongType(cv.valueType(), (Set<ConfigValueType>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigValueType[]{ConfigValueType.OBJECT}))), ConfigValueLocation$.MODULE$.apply(cv.origin()), PathUtil$.MODULE$.joinPath((List<String>)curr.reverse())));
        }
        return either;
    }

    private package$() {
        MODULE$ = this;
    }
}

