/*
 * Decompiled with CFR 0.152.
 */
package pureconfig.backend;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import pureconfig.error.CannotParse;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigReaderFailures$;
import pureconfig.error.ConfigValueLocation;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.ThrowableFailure;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class ConfigFactoryWrapper$ {
    public static ConfigFactoryWrapper$ MODULE$;

    static {
        new ConfigFactoryWrapper$();
    }

    public Either<ConfigReaderFailures, BoxedUnit> invalidateCaches() {
        return this.unsafeToEither((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConfigFactory.invalidateCaches());
    }

    public Either<ConfigReaderFailures, Config> load() {
        return this.unsafeToEither((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.load());
    }

    public Either<ConfigReaderFailures, Config> parseFile(Path path) {
        return this.unsafeToEither((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)path.toFile()));
    }

    public Either<ConfigReaderFailures, Config> loadFile(Path path) {
        return this.parseFile(path).right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.unsafeToEither((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.load((Config)rawConfig)));
    }

    private <A> Either<ConfigReaderFailures, A> unsafeToEither(Function0<A> f) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(f.apply());
        }
        catch (Throwable throwable) {
            Left left;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ConfigException.Parse) {
                ConfigException.Parse parse = (ConfigException.Parse)throwable2;
                left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new CannotParse(parse.getLocalizedMessage(), ConfigValueLocation$.MODULE$.apply(parse.origin()))));
            } else if (throwable2 instanceof ConfigException) {
                ConfigException configException = (ConfigException)throwable2;
                left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new ThrowableFailure((Throwable)configException, ConfigValueLocation$.MODULE$.apply(configException.origin()), (Option<String>)None$.MODULE$)));
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    left = package$.MODULE$.Left().apply((Object)ConfigReaderFailures$.MODULE$.apply(new ThrowableFailure(e, (Option<ConfigValueLocation>)None$.MODULE$, (Option<String>)None$.MODULE$)));
                } else {
                    throw throwable;
                }
            }
            right = left;
        }
        return right;
    }

    private ConfigFactoryWrapper$() {
        MODULE$ = this;
    }
}

