/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigConvert$;
import pureconfig.ConfigReader;
import pureconfig.ConfigWriter;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigValueLocation$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig((Config)rawConfig, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConfig(namespace)).right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> ConfigConvert$.MODULE$.improveFailures(this.loadConfig((Config)rawConfig, reader), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)rawConfig.root())).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.loadFile(path).right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig((Config)rawConfig, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.loadFile(path).right().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getConfig(namespace)).right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> ConfigConvert$.MODULE$.improveFailures(this.loadConfig((Config)rawConfig, reader), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)rawConfig.root())).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, ConfigReader<Config> reader) {
        return reader.from((ConfigValue)conf.root());
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, ConfigReader<Config> reader) {
        ConfigObject cv = conf.getConfig(namespace).root();
        return ConfigConvert$.MODULE$.improveFailures(reader.from((ConfigValue)cv), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)cv));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig(conf.withFallback((ConfigMergeable)rawConfig), reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, ConfigReader<Config> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig(conf.withFallback((ConfigMergeable)rawConfig), namespace, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Object config;
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConfigReaderFailures failures = (ConfigReaderFailures)left.value();
                throw new ConfigReaderException<Config>(failures, ct);
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Object object = config = right.value();
        return (Config)object;
    }

    public <Config> Config loadConfigOrThrow(ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), ct);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(reader.from((ConfigValue)conf.root()), ct);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        ConfigObject cv = conf.getConfig(namespace).root();
        return this.getResultOrThrow(ConfigConvert$.MODULE$.improveFailures(reader.from((ConfigValue)cv), namespace, ConfigValueLocation$.MODULE$.apply((ConfigValue)cv)), ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        Either errorOrConfig = ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig(conf.withFallback((ConfigMergeable)rawConfig), reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
        return this.getResultOrThrow(errorOrConfig, ct);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ConfigReader<Config> reader, ClassTag<Config> ct) throws ConfigReaderException {
        Either errorOrConfig = ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> this.loadConfig(conf.withFallback((ConfigMergeable)rawConfig), namespace, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
        return this.getResultOrThrow(errorOrConfig, ct);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigWriter<Config> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot save configuration in file '", "' because it already exists and is a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath})));
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigWriter<Config> writer) {
        PrintStream printOutputStream = new PrintStream(outputStream);
        ConfigValue rawConf = writer.to(conf);
        printOutputStream.print(rawConf.render());
        printOutputStream.close();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, ConfigReader<Config> evidence$1) {
        return files.isEmpty() ? (Either)ConfigConvert$.MODULE$.failWithThrowable(new IllegalArgumentException("The config files to load must not be empty.")).apply((Object)None$.MODULE$) : ((Either)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)path -> ConfigFactoryWrapper$.MODULE$.parseFile((Path)path), Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either c1 = (Either)tuple2._1();
            Either c2 = (Either)tuple2._2();
            Either either = ConfigConvert$.MODULE$.combineResults(c1, c2, (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (Seq)x$3.$colon$plus(x$4, Seq$.MODULE$.canBuildFrom()));
            return either;
        })).right().map((Function1 & Serializable & scala.Serializable)x$5 -> ((Config)x$5.reduce((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.withFallback((ConfigMergeable)x$7))).resolve()).right().flatMap((Function1 & Serializable & scala.Serializable)conf -> this.loadConfig((Config)conf, evidence$1));
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ConfigReader<Config> evidence$2, ClassTag<Config> ct) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, evidence$2), ct);
    }

    private package$() {
        MODULE$ = this;
    }
}

