/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.AllowMissingKey;
import pureconfig.ConfigConvert$;
import pureconfig.ConfigCursor;
import pureconfig.ConfigCursor$;
import pureconfig.ConfigReader;
import pureconfig.ConfigWriter;
import pureconfig.ConvertHelpers$;
import pureconfig.Derivation;
import pureconfig.backend.ConfigFactoryWrapper$;
import pureconfig.backend.PathUtil$;
import pureconfig.error.CannotReadFile;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailure;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.ConfigValueLocation$;
import pureconfig.error.ThrowableFailure;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    private Either<ConfigReaderFailures, ConfigCursor> getValue(Config conf, String namespace, boolean allowNullLeaf) {
        Either either;
        try {
            either = package$.getValue$1(ConfigCursor$.MODULE$.apply((ConfigValue)conf.root(), (List<String>)Nil$.MODULE$), PathUtil$.MODULE$.splitPath(namespace), allowNullLeaf);
        }
        catch (ConfigException ex) {
            either = ConvertHelpers$.MODULE$.fail(new ThrowableFailure(ex, ConfigValueLocation$.MODULE$.apply(ex.origin())));
        }
        return either;
    }

    private <A> Either<ConfigReaderFailures, A> loadValue(Config conf, String namespace, Derivation<ConfigReader<A>> reader) {
        ConfigReader configReader = reader.value();
        return this.getValue(conf, namespace, reader.value() instanceof AllowMissingKey).right().flatMap((Function1 & Serializable & scala.Serializable)cur -> configReader.from((ConfigCursor)cur));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig("", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> MODULE$.loadValue((Config)rawConfig, namespace, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfig(path, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.loadFile(path).right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> MODULE$.loadValue((Config)rawConfig, namespace, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.loadValue(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return this.loadValue(conf, namespace, reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, Derivation<ConfigReader<Config>> reader) {
        return this.loadConfigWithFallback(conf, "", reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigFactoryWrapper$.MODULE$.invalidateCaches().right().flatMap((Function1 & Serializable & scala.Serializable)_ -> ConfigFactoryWrapper$.MODULE$.load().right().flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> MODULE$.loadConfig(conf.withFallback((ConfigMergeable)rawConfig), namespace, reader).right().map((Function1 & Serializable & scala.Serializable)config -> config)));
    }

    private <Config> Config getResultOrThrow(Either<ConfigReaderFailures, Config> failuresOrResult, ClassTag<Config> ct) {
        Object config;
        Either<ConfigReaderFailures, Config> either = failuresOrResult;
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConfigReaderFailures failures = (ConfigReaderFailures)left.value();
                throw new ConfigReaderException<Config>(failures, ct);
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Object object = config = right.value();
        return (Config)object;
    }

    public <Config> Config loadConfigOrThrow(ClassTag<Config> evidence$1, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(reader), evidence$1);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ClassTag<Config> evidence$2, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(namespace, reader), evidence$2);
    }

    public <Config> Config loadConfigOrThrow(Path path, ClassTag<Config> evidence$3, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, reader), evidence$3);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ClassTag<Config> evidence$4, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(path, namespace, reader), evidence$4);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ClassTag<Config> evidence$5, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, reader), evidence$5);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ClassTag<Config> evidence$6, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfig(conf, namespace, reader), evidence$6);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ClassTag<Config> evidence$7, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, reader), evidence$7);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ClassTag<Config> evidence$8, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigWithFallback(conf, namespace, reader), evidence$8);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists").toString());
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists and is a directory").toString());
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), options, writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> ConfigRenderOptions saveConfigAsPropertyFile$default$4() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) {
        OutputStreamWriter printOutputStream = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        ConfigValue rawConf = writer.value().to(conf);
        printOutputStream.write(rawConf.render(options));
        printOutputStream.close();
    }

    public <Config> ConfigRenderOptions saveConfigToStream$default$3() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, boolean failOnReadError, Derivation<ConfigReader<Config>> reader) {
        return ((Either)((TraversableOnce)((TraversableLike)files.map((Function1 & Serializable & scala.Serializable)path -> ConfigFactoryWrapper$.MODULE$.parseFile((Path)path), Traversable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            ConfigReaderFailures failures;
            Either either = x0$1;
            Object object = either instanceof Left && (failures = (ConfigReaderFailures)(left = (Left)either).value()).toList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$loadConfigFromFiles$3(x$1))) && !failOnReadError ? scala.package$.MODULE$.Right().apply((Object)ConfigFactory.empty()) : either;
            return object;
        }, Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)ConfigFactory.empty()), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either c1 = (Either)tuple2._1();
            Either c2 = (Either)tuple2._2();
            Either either = ConfigConvert$.MODULE$.combineResults(c1, c2, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.withFallback((ConfigMergeable)x$3));
            return either;
        })).right().flatMap((Function1 & Serializable & scala.Serializable)conf -> MODULE$.loadConfig(conf.resolve(), reader));
    }

    public <Config> boolean loadConfigFromFiles$default$2() {
        return false;
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ClassTag<Config> evidence$9, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return this.getResultOrThrow(this.loadConfigFromFiles(files, this.loadConfigFromFiles$default$2(), reader), evidence$9);
    }

    private static final Either getValue$1(ConfigCursor cur, List path, boolean allowNullLeaf$1) {
        Right right;
        List list = path;
        if (Nil$.MODULE$.equals(list)) {
            right = scala.package$.MODULE$.Right().apply((Object)cur);
        } else if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String key = (String)colon2.head();
            List remaining = colon2.tl$access$1();
            right = cur.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)objCur -> (remaining.nonEmpty() || !allowNullLeaf$1 ? objCur.atKey(key) : scala.package$.MODULE$.Right().apply((Object)objCur.atKeyOrUndefined(key))).right().flatMap((Function1 & Serializable & scala.Serializable)keyCur -> package$.getValue$1(keyCur, remaining, allowNullLeaf$1).right().map((Function1 & Serializable & scala.Serializable)finalCur -> finalCur)));
        } else {
            throw new MatchError((Object)list);
        }
        return right;
    }

    public static final /* synthetic */ boolean $anonfun$loadConfigFromFiles$3(ConfigReaderFailure x$1) {
        return x$1 instanceof CannotReadFile;
    }

    private package$() {
        MODULE$ = this;
    }
}

