/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.prefser.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;

public final class Prefser {
    private final SharedPreferences preferences;
    private final SharedPreferences.Editor editor;
    private final Map<Class, Getter> getters = new HashMap<Class, Getter>();
    private final Gson gson = new Gson();
    private SharedPreferences.OnSharedPreferenceChangeListener onChangeListener;

    public Prefser(Context context) {
        this(PreferenceManager.getDefaultSharedPreferences((Context)context));
    }

    public Prefser(SharedPreferences sharedPreferences) {
        this.checkNotNull(sharedPreferences, "sharedPreferences == null");
        this.preferences = sharedPreferences;
        this.editor = this.preferences.edit();
        this.createMapOfGetters();
    }

    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    public <T> T get(String key, Class classOfT) {
        this.checkNotNull(key, "key == null");
        if (!this.contains(key)) {
            throw new RuntimeException(String.format("Value with key %s could not be found", key));
        }
        return this.get(key, classOfT, null);
    }

    public <T> T get(String key, Class classOfT, T defaultValue) {
        this.checkNotNull(key, "key == null");
        this.checkNotNull(classOfT, "classOfT == null");
        for (Map.Entry<Class, Getter> entry : this.getters.entrySet()) {
            if (!classOfT.equals(entry.getKey())) continue;
            return entry.getValue().get(key, classOfT, defaultValue);
        }
        if (this.contains(key)) {
            return (T)this.gson.fromJson(this.preferences.getString(key, null), classOfT);
        }
        return defaultValue;
    }

    public Observable<String> fromDefaultPreferences() {
        return this.from(this.preferences);
    }

    public Observable<String> from(final SharedPreferences sharedPreferences) {
        this.checkNotNull(sharedPreferences, "sharedPreferences == null");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(final Subscriber<? super String> subscriber) {
                Prefser.this.onChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

                    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                        subscriber.onNext((Object)key);
                    }
                };
                sharedPreferences.registerOnSharedPreferenceChangeListener(Prefser.this.onChangeListener);
            }
        });
    }

    public void put(String key, Object value) {
        this.checkNotNull(key, "key == null");
        this.checkNotNull(value, "value == null");
        if (!this.getters.containsKey(value.getClass())) {
            value = this.gson.toJson(value);
        }
        this.editor.putString(key, String.valueOf(value)).apply();
    }

    public void remove(String key) {
        this.checkNotNull(key, "key == null");
        if (!this.contains(key)) {
            return;
        }
        this.editor.remove(key).apply();
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.editor.clear().apply();
    }

    public int size() {
        return this.preferences.getAll().size();
    }

    private void createMapOfGetters() {
        this.getters.put(Boolean.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Boolean.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }
        });
        this.getters.put(Float.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Float.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }
        });
        this.getters.put(Integer.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Integer.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }
        });
        this.getters.put(Long.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Long.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }
        });
        this.getters.put(Double.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Double.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }
        });
        this.getters.put(String.class, new Getter(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Prefser.this.preferences.getString(key, String.valueOf(defaultValue));
            }
        });
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static interface Getter {
        public <T> T get(String var1, Class var2, T var3);
    }
}

