/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.prefser.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class Prefser {
    private final SharedPreferences preferences;
    private final SharedPreferences.Editor editor;
    private final Map<Class, Accessor> accessors = new HashMap<Class, Accessor>();
    private final Gson gson = new Gson();
    private SharedPreferences.OnSharedPreferenceChangeListener onChangeListener;

    public Prefser(Context context) {
        this(PreferenceManager.getDefaultSharedPreferences((Context)context));
    }

    public Prefser(SharedPreferences sharedPreferences) {
        this.checkNotNull(sharedPreferences, "sharedPreferences == null");
        this.preferences = sharedPreferences;
        this.editor = this.preferences.edit();
        this.initAccessors();
    }

    public SharedPreferences getPreferences() {
        return this.preferences;
    }

    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    public <T> Observable<T> observe(final String key, final Class classOfT, final T defaultValue) {
        return this.observe(this.preferences).filter((Func1)new Func1<String, Boolean>(){

            public Boolean call(String filteredKey) {
                return key.equals(filteredKey);
            }
        }).map(new Func1<String, T>(){

            public T call(String s) {
                return Prefser.this.get(key, classOfT, defaultValue);
            }
        });
    }

    public <T> T get(String key, Class classOfT, T defaultValue) {
        this.checkNotNull(key, "key == null");
        this.checkNotNull(classOfT, "classOfT == null");
        for (Map.Entry<Class, Accessor> entry : this.accessors.entrySet()) {
            if (!classOfT.equals(entry.getKey())) continue;
            return entry.getValue().get(key, classOfT, defaultValue);
        }
        if (this.contains(key)) {
            return (T)this.gson.fromJson(this.preferences.getString(key, null), classOfT);
        }
        return defaultValue;
    }

    public Observable<String> observeDefaultPreferences() {
        return this.observe(this.preferences);
    }

    public Observable<String> observe(final SharedPreferences sharedPreferences) {
        this.checkNotNull(sharedPreferences, "sharedPreferences == null");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

            public void call(final Subscriber<? super String> subscriber) {
                Prefser.this.onChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

                    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                        subscriber.onNext((Object)key);
                    }
                };
                sharedPreferences.registerOnSharedPreferenceChangeListener(Prefser.this.onChangeListener);
            }
        });
    }

    public void put(String key, Object value) {
        this.checkNotNull(key, "key == null");
        this.checkNotNull(value, "value == null");
        if (!this.accessors.containsKey(value.getClass())) {
            value = this.gson.toJson(value);
            this.editor.putString(key, String.valueOf(value)).apply();
            return;
        }
        Class<?> classOfValue = value.getClass();
        for (Map.Entry<Class, Accessor> entry : this.accessors.entrySet()) {
            if (!classOfValue.equals(entry.getKey())) continue;
            entry.getValue().put(key, value);
            break;
        }
    }

    public void remove(String key) {
        this.checkNotNull(key, "key == null");
        if (!this.contains(key)) {
            return;
        }
        this.editor.remove(key).apply();
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.editor.clear().apply();
    }

    public int size() {
        return this.preferences.getAll().size();
    }

    private void initAccessors() {
        this.accessors.put(Boolean.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Boolean.valueOf(Prefser.this.preferences.getBoolean(key, ((Boolean)defaultValue).booleanValue()));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putBoolean(key, ((Boolean)value).booleanValue()).apply();
            }
        });
        this.accessors.put(Float.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Float.valueOf(Prefser.this.preferences.getFloat(key, ((Float)defaultValue).floatValue()));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putFloat(key, ((Float)value).floatValue()).apply();
            }
        });
        this.accessors.put(Integer.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Integer.valueOf(Prefser.this.preferences.getInt(key, ((Integer)defaultValue).intValue()));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putInt(key, ((Integer)value).intValue()).apply();
            }
        });
        this.accessors.put(Long.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Long.valueOf(Prefser.this.preferences.getLong(key, ((Long)defaultValue).longValue()));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putLong(key, ((Long)value).longValue()).apply();
            }
        });
        this.accessors.put(Double.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Double.valueOf(Prefser.this.preferences.getString(key, String.valueOf(defaultValue)));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putString(key, String.valueOf(value)).apply();
            }
        });
        this.accessors.put(String.class, new Accessor(){

            @Override
            public <T> T get(String key, Class classOfT, T defaultValue) {
                return (T)Prefser.this.preferences.getString(key, String.valueOf(defaultValue));
            }

            @Override
            public void put(String key, Object value) {
                Prefser.this.editor.putString(key, String.valueOf(value)).apply();
            }
        });
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static interface Accessor {
        public <T> T get(String var1, Class var2, T var3);

        public void put(String var1, Object var2);
    }
}

