/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.prefser.library;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeToken<T> {
    private final Type type;

    public TypeToken() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterizedSuperclass = (ParameterizedType)superclass;
        this.type = parameterizedSuperclass.getActualTypeArguments()[0];
    }

    private TypeToken(Class<?> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException("classOfT == null");
        }
        this.type = classOfT;
    }

    static <T> TypeToken<T> fromClass(Class<T> classForT) {
        return new TypeToken<T>((Class)classForT){};
    }

    static <T> TypeToken<T> fromValue(T value) {
        return new TypeToken<T>((Class)value.getClass()){};
    }

    public Type getType() {
        return this.type;
    }
}

