/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.prefser.library;

import android.content.SharedPreferences;
import com.github.pwittchen.prefser.library.Accessor;
import com.github.pwittchen.prefser.library.AccessorsProvider;
import com.github.pwittchen.prefser.library.Preconditions;
import java.util.HashMap;
import java.util.Map;

class PreferencesAccessorsProvider
implements AccessorsProvider {
    private final SharedPreferences preferences;
    private final SharedPreferences.Editor editor;
    private final Map<Class<?>, Accessor<?>> accessors = new HashMap();

    PreferencesAccessorsProvider(SharedPreferences preferences, SharedPreferences.Editor editor) {
        Preconditions.checkNotNull(preferences, "preferences == null");
        Preconditions.checkNotNull(editor, "editor == null");
        this.preferences = preferences;
        this.editor = editor;
        this.createAccessors();
    }

    @Override
    public Map<Class<?>, Accessor<?>> getAccessors() {
        return this.accessors;
    }

    private void createAccessors() {
        this.createBooleanAccessor();
        this.createFloatAccessor();
        this.createIntegerAccessor();
        this.createLongAccessor();
        this.createDoubleAccessor();
        this.createStringAccessor();
    }

    private void createBooleanAccessor() {
        this.accessors.put(Boolean.class, new Accessor<Boolean>(){

            @Override
            public Boolean get(String key, Boolean defaultValue) {
                return PreferencesAccessorsProvider.this.preferences.getBoolean(key, defaultValue.booleanValue());
            }

            @Override
            public void put(String key, Boolean value) {
                PreferencesAccessorsProvider.this.editor.putBoolean(key, value.booleanValue()).apply();
            }
        });
    }

    private void createFloatAccessor() {
        this.accessors.put(Float.class, new Accessor<Float>(){

            @Override
            public Float get(String key, Float defaultValue) {
                return Float.valueOf(PreferencesAccessorsProvider.this.preferences.getFloat(key, defaultValue.floatValue()));
            }

            @Override
            public void put(String key, Float value) {
                PreferencesAccessorsProvider.this.editor.putFloat(key, value.floatValue()).apply();
            }
        });
    }

    private void createIntegerAccessor() {
        this.accessors.put(Integer.class, new Accessor<Integer>(){

            @Override
            public Integer get(String key, Integer defaultValue) {
                return PreferencesAccessorsProvider.this.preferences.getInt(key, defaultValue.intValue());
            }

            @Override
            public void put(String key, Integer value) {
                PreferencesAccessorsProvider.this.editor.putInt(key, value.intValue()).apply();
            }
        });
    }

    private void createLongAccessor() {
        this.accessors.put(Long.class, new Accessor<Long>(){

            @Override
            public Long get(String key, Long defaultValue) {
                return PreferencesAccessorsProvider.this.preferences.getLong(key, defaultValue.longValue());
            }

            @Override
            public void put(String key, Long value) {
                PreferencesAccessorsProvider.this.editor.putLong(key, value.longValue()).apply();
            }
        });
    }

    private void createDoubleAccessor() {
        this.accessors.put(Double.class, new Accessor<Double>(){

            @Override
            public Double get(String key, Double defaultValue) {
                return Double.valueOf(PreferencesAccessorsProvider.this.preferences.getString(key, String.valueOf(defaultValue)));
            }

            @Override
            public void put(String key, Double value) {
                PreferencesAccessorsProvider.this.editor.putString(key, String.valueOf(value)).apply();
            }
        });
    }

    private void createStringAccessor() {
        this.accessors.put(String.class, new Accessor<String>(){

            @Override
            public String get(String key, String defaultValue) {
                return PreferencesAccessorsProvider.this.preferences.getString(key, String.valueOf(defaultValue));
            }

            @Override
            public void put(String key, String value) {
                PreferencesAccessorsProvider.this.editor.putString(key, String.valueOf(value)).apply();
            }
        });
    }
}

