/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.prefser.library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import com.github.pwittchen.prefser.library.Accessor;
import com.github.pwittchen.prefser.library.AccessorsProvider;
import com.github.pwittchen.prefser.library.GsonConverter;
import com.github.pwittchen.prefser.library.JsonConverter;
import com.github.pwittchen.prefser.library.Preconditions;
import com.github.pwittchen.prefser.library.PreferencesAccessorsProvider;
import com.github.pwittchen.prefser.library.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subscriptions.Subscriptions;

public class Prefser {
    private static final String KEY_IS_NULL = "key == null";
    private static final String CLASS_OF_T_IS_NULL = "classOfT == null";
    private static final String TYPE_TOKEN_OF_T_IS_NULL = "typeTokenOfT == null";
    private static final String VALUE_IS_NULL = "value == null";
    private final SharedPreferences preferences;
    private final SharedPreferences.Editor editor;
    private final JsonConverter jsonConverter;
    private final AccessorsProvider accessorProvider;

    public Prefser(@NonNull Context context) {
        this(context, (JsonConverter)new GsonConverter());
    }

    public Prefser(@NonNull Context context, @NonNull JsonConverter jsonConverter) {
        this(PreferenceManager.getDefaultSharedPreferences((Context)context), jsonConverter);
    }

    public Prefser(@NonNull SharedPreferences sharedPreferences) {
        this(sharedPreferences, (JsonConverter)new GsonConverter());
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public Prefser(@NonNull SharedPreferences sharedPreferences, @NonNull JsonConverter jsonConverter) {
        Preconditions.checkNotNull(sharedPreferences, "sharedPreferences == null");
        Preconditions.checkNotNull(jsonConverter, "jsonConverter == null");
        this.preferences = sharedPreferences;
        this.editor = this.preferences.edit();
        this.jsonConverter = jsonConverter;
        this.accessorProvider = new PreferencesAccessorsProvider(this.preferences, this.editor);
    }

    public SharedPreferences getPreferences() {
        return this.preferences;
    }

    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    public <T> Observable<T> getAndObserve(String key, Class<T> classOfT, T defaultValue) {
        return this.getAndObserve(key, TypeToken.fromClass(classOfT), defaultValue);
    }

    public <T> Observable<T> getAndObserve(final String key, final TypeToken<T> typeTokenOfT, final T defaultValue) {
        return this.observe(key, typeTokenOfT, defaultValue).mergeWith(Observable.defer((Func0)new Func0<Observable<T>>(){

            public Observable<T> call() {
                return Observable.just((Object)Prefser.this.get(key, typeTokenOfT, defaultValue));
            }
        }));
    }

    public <T> Observable<T> observe(@NonNull String key, @NonNull Class<T> classOfT, T defaultValue) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        Preconditions.checkNotNull(classOfT, CLASS_OF_T_IS_NULL);
        return this.observe(key, TypeToken.fromClass(classOfT), defaultValue);
    }

    public <T> Observable<T> observe(final @NonNull String key, final @NonNull TypeToken<T> typeTokenOfT, final T defaultValue) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        Preconditions.checkNotNull(typeTokenOfT, TYPE_TOKEN_OF_T_IS_NULL);
        return this.observePreferences().filter((Func1)new Func1<String, Boolean>(){

            public Boolean call(String filteredKey) {
                return key.equals(filteredKey);
            }
        }).map(new Func1<String, T>(){

            public T call(String s) {
                return Prefser.this.get(key, typeTokenOfT, defaultValue);
            }
        });
    }

    public <T> T get(@NonNull String key, @NonNull Class<T> classOfT, T defaultValue) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        Preconditions.checkNotNull(classOfT, CLASS_OF_T_IS_NULL);
        if (!this.contains(key) && defaultValue == null) {
            return null;
        }
        return this.get(key, TypeToken.fromClass(classOfT), defaultValue);
    }

    public <T> T get(@NonNull String key, @NonNull TypeToken<T> typeTokenOfT, T defaultValue) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        Preconditions.checkNotNull(typeTokenOfT, TYPE_TOKEN_OF_T_IS_NULL);
        Type typeOfT = typeTokenOfT.getType();
        for (Map.Entry<Class<?>, Accessor<?>> entry : this.accessorProvider.getAccessors().entrySet()) {
            if (!typeOfT.equals(entry.getKey())) continue;
            Accessor<?> accessor = entry.getValue();
            return (T)accessor.get(key, defaultValue);
        }
        if (this.contains(key)) {
            return this.jsonConverter.fromJson(this.preferences.getString(key, null), typeOfT);
        }
        return defaultValue;
    }

    public Observable<String> observePreferences() {
        return Observable.unsafeCreate((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){
            Collection<OnChangeListener> listenerReferences = Collections.synchronizedList(new ArrayList());

            public void call(Subscriber<? super String> subscriber) {
                final OnChangeListener onChangeListener = new OnChangeListener(subscriber);
                Prefser.this.preferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)onChangeListener);
                this.listenerReferences.add(onChangeListener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        Prefser.this.preferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)onChangeListener);
                        listenerReferences.remove(onChangeListener);
                    }
                }));
            }
        });
    }

    public <T> void put(@NonNull String key, @NonNull T value) {
        Preconditions.checkNotNull(value, VALUE_IS_NULL);
        this.put(key, value, TypeToken.fromValue(value));
    }

    public <T> void put(@NonNull String key, @NonNull T value, @NonNull TypeToken<T> typeTokenOfT) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        Preconditions.checkNotNull(value, VALUE_IS_NULL);
        Preconditions.checkNotNull(typeTokenOfT, TYPE_TOKEN_OF_T_IS_NULL);
        if (!this.accessorProvider.getAccessors().containsKey(value.getClass())) {
            String jsonValue = this.jsonConverter.toJson(value, typeTokenOfT.getType());
            this.editor.putString(key, String.valueOf(jsonValue)).apply();
            return;
        }
        Class<?> classOfValue = value.getClass();
        for (Map.Entry<Class<?>, Accessor<?>> entry : this.accessorProvider.getAccessors().entrySet()) {
            if (!classOfValue.equals(entry.getKey())) continue;
            Accessor<?> accessor = entry.getValue();
            accessor.put(key, value);
        }
    }

    public void remove(@NonNull String key) {
        Preconditions.checkNotNull(key, KEY_IS_NULL);
        if (!this.contains(key)) {
            return;
        }
        this.editor.remove(key).apply();
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.editor.clear().apply();
    }

    public int size() {
        return this.preferences.getAll().size();
    }

    private static class OnChangeListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private final Subscriber<? super String> subscriber;

        public OnChangeListener(Subscriber<? super String> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (!this.subscriber.isUnsubscribed()) {
                this.subscriber.onNext((Object)key);
            }
        }
    }
}

