/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Looper;
import com.github.pwittchen.reactivenetwork.library.ConnectivityStatus;
import java.util.List;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public final class ReactiveNetwork {
    private static ConnectivityStatus status = ConnectivityStatus.UNDEFINED;

    public Observable<ConnectivityStatus> observeConnectivity(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ConnectivityStatus>(){

            public void call(final Subscriber<? super ConnectivityStatus> subscriber) {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        ConnectivityStatus newStatus = ReactiveNetwork.this.getConnectivityStatus(context);
                        if (newStatus != status) {
                            status = newStatus;
                            subscriber.onNext((Object)newStatus);
                        }
                    }
                };
                context.registerReceiver(receiver, filter);
                subscriber.add(ReactiveNetwork.this.unsubscribeInUiThread(new Action0(){

                    public void call() {
                        context.unregisterReceiver(receiver);
                    }
                }));
            }
        });
    }

    private ConnectivityStatus getConnectivityStatus(Context context) {
        String service = "connectivity";
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService(service);
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null) {
            if (networkInfo.getType() == 1) {
                return ConnectivityStatus.WIFI_CONNECTED;
            }
            if (networkInfo.getType() == 0) {
                return ConnectivityStatus.MOBILE_CONNECTED;
            }
        }
        return ConnectivityStatus.OFFLINE;
    }

    public Observable<List<ScanResult>> observeWifiAccessPoints(final Context context) {
        final WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        wifiManager.startScan();
        final IntentFilter filter = new IntentFilter("android.net.wifi.RSSI_CHANGED");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<ScanResult>>(){

            public void call(final Subscriber<? super List<ScanResult>> subscriber) {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        wifiManager.startScan();
                        subscriber.onNext((Object)wifiManager.getScanResults());
                    }
                };
                context.registerReceiver(receiver, filter);
                subscriber.add(ReactiveNetwork.this.unsubscribeInUiThread(new Action0(){

                    public void call() {
                        context.unregisterReceiver(receiver);
                    }
                }));
            }
        });
    }

    private Subscription unsubscribeInUiThread(final Action0 unsubscribe) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    unsubscribe.call();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Action0(){

                        public void call() {
                            unsubscribe.call();
                            inner.unsubscribe();
                        }
                    });
                }
            }
        });
    }
}

