/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import rx.functions.Func1;

public enum ConnectivityStatus {
    UNKNOWN("unknown"),
    WIFI_CONNECTED("connected to WiFi"),
    WIFI_CONNECTED_HAS_INTERNET("connected to WiFi (Internet available)"),
    WIFI_CONNECTED_HAS_NO_INTERNET("connected to WiFi (Internet not available)"),
    MOBILE_CONNECTED("connected to mobile network"),
    OFFLINE("offline");

    private final String status;

    private ConnectivityStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return this.status;
    }

    public static Func1<ConnectivityStatus, Boolean> isEqualTo(final ConnectivityStatus ... statuses) {
        return new Func1<ConnectivityStatus, Boolean>(){

            public Boolean call(ConnectivityStatus connectivityStatus) {
                boolean statuesAreEqual = false;
                for (ConnectivityStatus singleStatus : statuses) {
                    statuesAreEqual = singleStatus == connectivityStatus;
                }
                return statuesAreEqual;
            }
        };
    }

    public static Func1<ConnectivityStatus, Boolean> isNotEqualTo(final ConnectivityStatus ... statuses) {
        return new Func1<ConnectivityStatus, Boolean>(){

            public Boolean call(ConnectivityStatus connectivityStatus) {
                boolean statuesAreNotEqual = false;
                for (ConnectivityStatus singleStatus : statuses) {
                    statuesAreNotEqual = singleStatus != connectivityStatus;
                }
                return statuesAreNotEqual;
            }
        };
    }
}

