/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import android.net.NetworkInfo;
import com.github.pwittchen.reactivenetwork.library.Connectivity;
import rx.functions.Func1;

public class ConnectivityPredicate {
    private ConnectivityPredicate() {
    }

    public static Func1<Connectivity, Boolean> hasState(final NetworkInfo.State ... states) {
        return new Func1<Connectivity, Boolean>(){

            public Boolean call(Connectivity connectivity) {
                for (NetworkInfo.State state : states) {
                    if (connectivity.getState() != state) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Func1<Connectivity, Boolean> hasType(int ... types) {
        final int[] extendedTypes = ConnectivityPredicate.appendUnknownNetworkTypeToTypes(types);
        return new Func1<Connectivity, Boolean>(){

            public Boolean call(Connectivity connectivity) {
                for (int type : extendedTypes) {
                    if (connectivity.getType() != type) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected static int[] appendUnknownNetworkTypeToTypes(int[] types) {
        int i = 0;
        int[] extendedTypes = new int[types.length + 1];
        int[] nArray = types;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int type;
            extendedTypes[i] = type = nArray[j];
            ++i;
        }
        extendedTypes[i] = -1;
        return extendedTypes;
    }
}

