/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.internet.observing.strategy;

import com.github.pwittchen.reactivenetwork.library.Preconditions;
import com.github.pwittchen.reactivenetwork.library.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.internet.observing.error.ErrorHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class WalledGardenInternetObservingStrategy
implements InternetObservingStrategy {
    private static final String DEFAULT_HOST = "https://clients3.google.com/generate_204";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    @Override
    public Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, final int port, final int timeoutInMs, final ErrorHandler errorHandler) {
        this.checkPreconditions(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, errorHandler);
        final String adjustedHost = this.adjustHost(host);
        return Observable.interval((long)initialIntervalInMs, (long)intervalInMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Func1)new Func1<Long, Boolean>(){

            public Boolean call(Long aLong) {
                return WalledGardenInternetObservingStrategy.this.isConnected(adjustedHost, port, timeoutInMs, errorHandler);
            }
        }).distinctUntilChanged();
    }

    @Override
    public String getDefaultPingHost() {
        return DEFAULT_HOST;
    }

    protected String adjustHost(String host) {
        if (!host.startsWith(HTTP_PROTOCOL) && !host.startsWith(HTTPS_PROTOCOL)) {
            return HTTPS_PROTOCOL.concat(host);
        }
        return host;
    }

    private void checkPreconditions(int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        Preconditions.checkGreaterOrEqualToZero(initialIntervalInMs, "initialIntervalInMs is not a positive number");
        Preconditions.checkGreaterThanZero(intervalInMs, "intervalInMs is not a positive number");
        Preconditions.checkNotNullOrEmpty(host, "host is null or empty");
        Preconditions.checkGreaterThanZero(port, "port is not a positive number");
        Preconditions.checkGreaterThanZero(timeoutInMs, "timeoutInMs is not a positive number");
        Preconditions.checkNotNull(errorHandler, "errorHandler is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean isConnected(String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = host.startsWith(HTTPS_PROTOCOL) ? this.createHttpsUrlConnection(host, port, timeoutInMs) : this.createHttpUrlConnection(host, port, timeoutInMs);
            Boolean bl = urlConnection.getResponseCode() == 204;
            return bl;
        }
        catch (IOException e) {
            errorHandler.handleError(e, "Could not establish connection with WalledGardenStrategy");
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    protected HttpURLConnection createHttpUrlConnection(String host, int port, int timeoutInMs) throws IOException {
        URL initialUrl = new URL(host);
        URL url = new URL(initialUrl.getProtocol(), initialUrl.getHost(), port, initialUrl.getFile());
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(timeoutInMs);
        urlConnection.setReadTimeout(timeoutInMs);
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setUseCaches(false);
        return urlConnection;
    }

    protected HttpsURLConnection createHttpsUrlConnection(String host, int port, int timeoutInMs) throws IOException {
        URL initialUrl = new URL(host);
        URL url = new URL(initialUrl.getProtocol(), initialUrl.getHost(), port, initialUrl.getFile());
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(timeoutInMs);
        urlConnection.setReadTimeout(timeoutInMs);
        urlConnection.setInstanceFollowRedirects(false);
        urlConnection.setUseCaches(false);
        return urlConnection;
    }
}

