/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.network.observing.strategy;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.PowerManager;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.Connectivity;
import com.github.pwittchen.reactivenetwork.library.network.observing.NetworkObservingStrategy;
import rx.Observable;
import rx.functions.Action0;
import rx.subjects.PublishSubject;

@TargetApi(value=23)
public class MarshmallowNetworkObservingStrategy
implements NetworkObservingStrategy {
    private ConnectivityManager.NetworkCallback networkCallback;
    private PublishSubject<Connectivity> connectivitySubject = PublishSubject.create();
    private BroadcastReceiver idleReceiver;

    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        String service = "connectivity";
        final ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkCallback = this.createNetworkCallback(context);
        this.registerIdleReceiver(context);
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).addCapability(13).build();
        manager.registerNetworkCallback(request, this.networkCallback);
        return this.connectivitySubject.asObservable().onBackpressureLatest().doOnUnsubscribe(new Action0(){

            public void call() {
                MarshmallowNetworkObservingStrategy.this.tryToUnregisterCallback(manager);
                MarshmallowNetworkObservingStrategy.this.tryToUnregisterReceiver(context);
            }
        }).startWith((Object)Connectivity.create(context)).distinctUntilChanged();
    }

    private void registerIdleReceiver(Context context) {
        IntentFilter filter = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        this.idleReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (MarshmallowNetworkObservingStrategy.this.isIdleMode(context)) {
                    MarshmallowNetworkObservingStrategy.this.connectivitySubject.onNext((Object)Connectivity.create());
                } else {
                    MarshmallowNetworkObservingStrategy.this.connectivitySubject.onNext((Object)Connectivity.create(context));
                }
            }
        };
        context.registerReceiver(this.idleReceiver, filter);
    }

    private boolean isIdleMode(Context context) {
        String packageName = context.getPackageName();
        PowerManager manager = (PowerManager)context.getSystemService("power");
        boolean isIgnoringOptimizations = manager.isIgnoringBatteryOptimizations(packageName);
        return manager.isDeviceIdleMode() && !isIgnoringOptimizations;
    }

    private void tryToUnregisterCallback(ConnectivityManager manager) {
        try {
            manager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception exception) {
            this.onError("could not unregister network callback", exception);
        }
    }

    private void tryToUnregisterReceiver(Context context) {
        try {
            context.unregisterReceiver(this.idleReceiver);
        }
        catch (Exception exception) {
            this.onError("could not unregister receiver", exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    private ConnectivityManager.NetworkCallback createNetworkCallback(final Context context) {
        return new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                MarshmallowNetworkObservingStrategy.this.connectivitySubject.onNext((Object)Connectivity.create(context));
            }

            public void onLost(Network network) {
                MarshmallowNetworkObservingStrategy.this.connectivitySubject.onNext((Object)Connectivity.create(context));
            }
        };
    }
}

