/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Looper;
import com.github.pwittchen.reactivenetwork.library.ConnectivityStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public class ReactiveNetwork {
    private static final String DEFAULT_PING_HOST = "www.google.com";
    private static final int DEFAULT_PING_PORT = 80;
    private static final int DEFAULT_PING_INTERVAL_IN_MS = 2000;
    private static final int DEFAULT_PING_TIMEOUT_IN_MS = 2000;
    private ConnectivityStatus status = ConnectivityStatus.UNKNOWN;

    public Observable<ConnectivityStatus> observeNetworkConnectivity(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ConnectivityStatus>(){

            public void call(final Subscriber<? super ConnectivityStatus> subscriber) {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        ConnectivityStatus newStatus = ReactiveNetwork.this.getConnectivityStatus(context);
                        if (newStatus != ReactiveNetwork.this.status) {
                            ReactiveNetwork.this.status = newStatus;
                            subscriber.onNext((Object)newStatus);
                        }
                    }
                };
                context.registerReceiver(receiver, filter);
                subscriber.add(ReactiveNetwork.this.unsubscribeInUiThread(new Action0(){

                    public void call() {
                        context.unregisterReceiver(receiver);
                    }
                }));
            }
        }).defaultIfEmpty((Object)ConnectivityStatus.OFFLINE);
    }

    public ConnectivityStatus getConnectivityStatus(Context context) {
        String service = "connectivity";
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return ConnectivityStatus.OFFLINE;
        }
        if (networkInfo.getType() == 1) {
            return ConnectivityStatus.WIFI_CONNECTED;
        }
        if (networkInfo.getType() == 0) {
            return ConnectivityStatus.MOBILE_CONNECTED;
        }
        return ConnectivityStatus.OFFLINE;
    }

    public Observable<Boolean> observeInternetConnectivity() {
        return this.observeInternetConnectivity(2000, DEFAULT_PING_HOST, 80, 2000);
    }

    public Observable<Boolean> observeInternetConnectivity(int interval, final String host, final int port, final int timeout) {
        return Observable.interval((long)interval, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Func1)new Func1<Long, Boolean>(){

            public Boolean call(Long tick) {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(host, port), timeout);
                    return socket.isConnected();
                }
                catch (IOException e) {
                    return Boolean.FALSE;
                }
            }
        }).distinctUntilChanged();
    }

    private Subscription unsubscribeInUiThread(final Action0 unsubscribe) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    unsubscribe.call();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Action0(){

                        public void call() {
                            unsubscribe.call();
                            inner.unsubscribe();
                        }
                    });
                }
            }
        });
    }
}

