/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.github.pwittchen.reactivenetwork.library.Preconditions;
import rx.functions.Func1;

public class Connectivity {
    private static final NetworkInfo.State DEFAULT_STATE = NetworkInfo.State.DISCONNECTED;
    private static final int DEFAULT_TYPE = -1;
    private static final String DEFAULT_NAME = "NONE";
    private NetworkInfo.State state;
    private int type;
    private String name;

    public static Connectivity create() {
        return new Connectivity();
    }

    public static Connectivity create(Context context) {
        Preconditions.checkNotNull(context, "context == null");
        return new Connectivity(context);
    }

    public static Connectivity create(NetworkInfo.State state, int type, String name) {
        Preconditions.checkNotNull(state, "state == null");
        Preconditions.checkNotNullOrEmpty(name, "name is null or empty");
        return new Connectivity(state, type, name);
    }

    private Connectivity() {
        this(DEFAULT_STATE, -1, DEFAULT_NAME);
    }

    private Connectivity(Context context) {
        NetworkInfo networkInfo = this.getNetworkInfo(context);
        if (networkInfo == null) {
            this.initAttributes(DEFAULT_STATE, -1, DEFAULT_NAME);
        } else {
            this.initAttributes(networkInfo.getState(), networkInfo.getType(), networkInfo.getTypeName());
        }
    }

    private Connectivity(NetworkInfo.State state, int type, String name) {
        this.initAttributes(state, type, name);
    }

    private NetworkInfo getNetworkInfo(Context context) {
        String service = "connectivity";
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        return manager.getActiveNetworkInfo();
    }

    private void initAttributes(NetworkInfo.State state, int type, String name) {
        this.state = state;
        this.type = type;
        this.name = name;
    }

    public NetworkInfo.State getState() {
        return this.state;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static Func1<Connectivity, Boolean> hasState(final NetworkInfo.State ... states) {
        return new Func1<Connectivity, Boolean>(){

            public Boolean call(Connectivity connectivity) {
                for (NetworkInfo.State state : states) {
                    if (connectivity.getState() != state) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Func1<Connectivity, Boolean> hasType(final int ... types) {
        return new Func1<Connectivity, Boolean>(){

            public Boolean call(Connectivity connectivity) {
                for (int type : types) {
                    if (connectivity.getType() != type) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public boolean isDefault() {
        return this.getState() == DEFAULT_STATE && this.getType() == -1;
    }

    public String toString() {
        return "Connectivity{state=" + this.state + ", type=" + this.type + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connectivity that = (Connectivity)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.state.hashCode();
        result = 31 * result + this.type;
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

