/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library;

import android.content.Context;
import android.os.Build;
import com.github.pwittchen.reactivenetwork.library.Connectivity;
import com.github.pwittchen.reactivenetwork.library.Preconditions;
import com.github.pwittchen.reactivenetwork.library.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.internet.observing.strategy.DefaultInternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.internet.socket.DefaultSocketErrorHandler;
import com.github.pwittchen.reactivenetwork.library.internet.socket.SocketErrorHandler;
import com.github.pwittchen.reactivenetwork.library.network.observing.NetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.network.observing.strategy.LollipopNetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.network.observing.strategy.PreLollipopNetworkObservingStrategy;
import rx.Observable;

public class ReactiveNetwork {
    public static final String LOG_TAG = "ReactiveNetwork";
    private static final String DEFAULT_PING_HOST = "www.google.com";
    private static final int DEFAULT_PING_PORT = 80;
    private static final int DEFAULT_PING_INTERVAL_IN_MS = 2000;
    private static final int DEFAULT_INITIAL_PING_INTERVAL_IN_MS = 0;
    private static final int DEFAULT_PING_TIMEOUT_IN_MS = 2000;

    protected ReactiveNetwork() {
    }

    public static ReactiveNetwork create() {
        return new ReactiveNetwork();
    }

    public static Observable<Connectivity> observeNetworkConnectivity(Context context) {
        boolean isAtLeastLollipop = Build.VERSION.SDK_INT >= 21;
        NetworkObservingStrategy strategy = isAtLeastLollipop ? new LollipopNetworkObservingStrategy() : new PreLollipopNetworkObservingStrategy();
        return ReactiveNetwork.observeNetworkConnectivity(context, strategy);
    }

    public static Observable<Connectivity> observeNetworkConnectivity(Context context, NetworkObservingStrategy strategy) {
        Preconditions.checkNotNull(context, "context == null");
        Preconditions.checkNotNull(strategy, "strategy == null");
        return strategy.observeNetworkConnectivity(context);
    }

    public static Observable<Boolean> observeInternetConnectivity() {
        return ReactiveNetwork.observeInternetConnectivity(0, 2000, DEFAULT_PING_HOST, 80, 2000, new DefaultSocketErrorHandler());
    }

    public static Observable<Boolean> observeInternetConnectivity(int intervalInMs, String host, int port, int timeoutInMs) {
        return ReactiveNetwork.observeInternetConnectivity(0, intervalInMs, host, port, timeoutInMs, new DefaultSocketErrorHandler());
    }

    public static Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs) {
        return ReactiveNetwork.observeInternetConnectivity(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, new DefaultSocketErrorHandler());
    }

    public static Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, SocketErrorHandler socketErrorHandler) {
        return ReactiveNetwork.observeInternetConnectivity(new DefaultInternetObservingStrategy(), initialIntervalInMs, intervalInMs, host, port, timeoutInMs, socketErrorHandler);
    }

    public static Observable<Boolean> observeInternetConnectivity(InternetObservingStrategy strategy, int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, SocketErrorHandler socketErrorHandler) {
        Preconditions.checkNotNull(strategy, "strategy == null");
        return strategy.observeInternetConnectivity(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, socketErrorHandler);
    }
}

