/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.internet.observing.strategy;

import com.github.pwittchen.reactivenetwork.library.Preconditions;
import com.github.pwittchen.reactivenetwork.library.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.internet.socket.SocketErrorHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DefaultInternetObservingStrategy
implements InternetObservingStrategy {
    @Override
    public Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, final String host, final int port, final int timeoutInMs, final SocketErrorHandler socketErrorHandler) {
        Preconditions.checkGreaterOrEqualToZero(initialIntervalInMs, "initialIntervalInMs is not a positive number");
        Preconditions.checkGreaterThanZero(intervalInMs, "intervalInMs is not a positive number");
        Preconditions.checkNotNullOrEmpty(host, "host is null or empty");
        Preconditions.checkGreaterThanZero(port, "port is not a positive number");
        Preconditions.checkGreaterThanZero(timeoutInMs, "timeoutInMs is not a positive number");
        Preconditions.checkNotNull(socketErrorHandler, "socketErrorHandler is null");
        return Observable.interval((long)initialIntervalInMs, (long)intervalInMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Func1)new Func1<Long, Boolean>(){
            boolean isConnected;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean call(Long tick) {
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(host, port), timeoutInMs);
                    this.isConnected = socket.isConnected();
                }
                catch (IOException e) {
                    this.isConnected = Boolean.FALSE;
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException exception) {
                        socketErrorHandler.handleErrorDuringClosingSocket(exception);
                    }
                }
                return this.isConnected;
            }
        }).distinctUntilChanged();
    }
}

