/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.network.observing.strategy;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.Connectivity;
import com.github.pwittchen.reactivenetwork.library.network.observing.NetworkObservingStrategy;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;

@TargetApi(value=21)
public class LollipopNetworkObservingStrategy
implements NetworkObservingStrategy {
    private static final String ON_ERROR_MSG = "could not unregister network callback";
    private ConnectivityManager.NetworkCallback networkCallback;

    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        String service = "connectivity";
        final ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Connectivity>(){

            public void call(Subscriber<? super Connectivity> subscriber) {
                LollipopNetworkObservingStrategy.this.networkCallback = LollipopNetworkObservingStrategy.this.createNetworkCallback((Subscriber<? super Connectivity>)subscriber, context);
                NetworkRequest networkRequest = new NetworkRequest.Builder().build();
                manager.registerNetworkCallback(networkRequest, LollipopNetworkObservingStrategy.this.networkCallback);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                LollipopNetworkObservingStrategy.this.tryToUnregisterCallback(manager);
            }
        }).startWith((Object)Connectivity.create(context)).distinctUntilChanged();
    }

    private void tryToUnregisterCallback(ConnectivityManager manager) {
        try {
            manager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception exception) {
            this.onError(ON_ERROR_MSG, exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    private ConnectivityManager.NetworkCallback createNetworkCallback(final Subscriber<? super Connectivity> subscriber, final Context context) {
        return new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                subscriber.onNext((Object)Connectivity.create(context));
            }

            public void onLost(Network network) {
                subscriber.onNext((Object)Connectivity.create(context));
            }
        };
    }
}

