/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.network.observing.strategy;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.Connectivity;
import com.github.pwittchen.reactivenetwork.library.network.observing.NetworkObservingStrategy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class PreLollipopNetworkObservingStrategy
implements NetworkObservingStrategy {
    private static final String ON_ERROR_MSG = "receiver was already unregistered";

    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Connectivity>(){

            public void call(final Subscriber<? super Connectivity> subscriber) {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        subscriber.onNext((Object)Connectivity.create(context));
                    }
                };
                context.registerReceiver(receiver, filter);
                subscriber.add(PreLollipopNetworkObservingStrategy.this.unsubscribeInUiThread(new Action0(){

                    public void call() {
                        PreLollipopNetworkObservingStrategy.this.tryToUnregisterReceiver(context, receiver);
                    }
                }));
            }
        }).defaultIfEmpty((Object)Connectivity.create());
    }

    private void tryToUnregisterReceiver(Context context, BroadcastReceiver receiver) {
        try {
            context.unregisterReceiver(receiver);
        }
        catch (Exception exception) {
            this.onError(ON_ERROR_MSG, exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    private Subscription unsubscribeInUiThread(final Action0 unsubscribe) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    unsubscribe.call();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Action0(){

                        public void call() {
                            unsubscribe.call();
                            inner.unsubscribe();
                        }
                    });
                }
            }
        });
    }
}

