/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.encryption;

import com.qishenghe.developassistant.exception.DevelopAssException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Util {
    private static final String DEFAULT_MESSAGE_DIGEST_NAME = "md5";
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final int DEFAULT_BASE_NUM = 16;
    private Charset charset;
    private int baseNum;

    public Md5Util() {
        this.charset = Charset.forName(DEFAULT_CHARSET_NAME);
        this.baseNum = 16;
    }

    public Md5Util(Charset charset, int baseNum) {
        this.charset = charset;
        this.baseNum = baseNum;
    }

    public String encryption(String str) {
        return this.encryption(str, this.charset, this.baseNum);
    }

    public String encryption(String str, Charset charset, int base) {
        byte[] digest;
        try {
            MessageDigest md5 = MessageDigest.getInstance(DEFAULT_MESSAGE_DIGEST_NAME);
            digest = md5.digest(str.getBytes(charset));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new DevelopAssException(Md5Util.class.getName() + " : cause : " + e.getMessage());
        }
        assert (digest != null);
        return new BigInteger(1, digest).toString(base);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getBaseNum() {
        return this.baseNum;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setBaseNum(int baseNum) {
        this.baseNum = baseNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Md5Util)) {
            return false;
        }
        Md5Util other = (Md5Util)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        return this.getBaseNum() == other.getBaseNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Md5Util;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + this.getBaseNum();
        return result;
    }

    public String toString() {
        return "Md5Util(charset=" + this.getCharset() + ", baseNum=" + this.getBaseNum() + ")";
    }
}

