/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.geometry;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryWktUtil {
    public static boolean judgeIntersects(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.intersects(geo2);
    }

    public static boolean judgeContains(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.contains(geo2);
    }

    public static boolean judgeCovers(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.covers(geo2);
    }

    public static boolean judgeCrosses(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.crosses(geo2);
    }

    public static boolean judgeEquals(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.equals(geo2);
    }

    public static Coordinate[] getCoordinate(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getCoordinates();
    }

    public static Geometry getReverse(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.reverse();
    }

    public static Geometry getConvexHull(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.convexHull();
    }

    public static Point getCentroid(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getCentroid();
    }

    public static int getGeometriesNum(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getNumGeometries();
    }

    public static int getPointNum(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getNumPoints();
    }

    public static String getGeometryType(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getGeometryType();
    }

    public static double getArea(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getArea();
    }

    public static double getLength(String wkt) throws ParseException {
        Geometry geo = new WKTReader().read(wkt);
        return geo.getLength();
    }

    public static Geometry calIntersection(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.intersection(geo2);
    }

    public static Geometry calUnion(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.union(geo2);
    }

    public static Geometry calDifference(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.difference(geo2);
    }

    public static Geometry calSymDifference(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.symDifference(geo2);
    }

    public static double calDistance(String wkt1, String wkt2) throws ParseException {
        Geometry geo1 = new WKTReader().read(wkt1);
        Geometry geo2 = new WKTReader().read(wkt2);
        return geo1.distance(geo2);
    }

    public static Geometry transGeometryWkt(String wkt) throws ParseException {
        return new WKTReader().read(wkt);
    }

    public static String transWktGeometry(Geometry geo) {
        return geo.toText();
    }
}

