/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.geometry;

import com.qishenghe.developassistant.exception.DevelopAssException;
import java.io.Serializable;
import java.util.Arrays;

public class Point
implements Serializable {
    private static final long serialVersionUID = 4716135120947817019L;
    private static final int DOUBLE_DIMENSION_X_IDX = 0;
    private static final int DOUBLE_DIMENSION_Y_IDX = 1;
    private double[] dimensionArr;

    public Point() {
        this.initArr(2);
    }

    public Point(int initNum) {
        this.initArr(initNum);
    }

    public Point(double x, double y) {
        this.initArr(2);
        this.dimensionArr[0] = x;
        this.dimensionArr[1] = y;
    }

    public Point(double ... dimensionArr) {
        this.initArr(dimensionArr.length);
        System.arraycopy(dimensionArr, 0, this.dimensionArr, 0, dimensionArr.length);
    }

    private void initArr(int initNum) {
        this.dimensionArr = new double[initNum];
    }

    public double getDimensionValue(int dimensionNum) {
        return this.dimensionArr[dimensionNum];
    }

    public boolean setDimensionValue(int dimensionNum, double value) {
        if (dimensionNum >= this.dimensionArr.length) {
            throw new DevelopAssException(Point.class.getName() + " : cause : \u7ef4\u5ea6\u6570\u7ec4\u8d8a\u754c\uff0c\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u6269\u5bb9");
        }
        this.dimensionArr[dimensionNum] = value;
        return true;
    }

    public double getX() {
        return this.getDimensionValue(0);
    }

    public double getY() {
        return this.getDimensionValue(1);
    }

    public boolean setX(double value) {
        return this.setDimensionValue(0, value);
    }

    public boolean setY(double value) {
        return this.setDimensionValue(1, value);
    }

    public double[] getDimensionArr() {
        return this.dimensionArr;
    }

    public void setDimensionArr(double[] dimensionArr) {
        this.dimensionArr = dimensionArr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getDimensionArr(), other.getDimensionArr());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getDimensionArr());
        return result;
    }

    public String toString() {
        return "Point(dimensionArr=" + Arrays.toString(this.getDimensionArr()) + ")";
    }
}

