/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.geoscience;

import com.qishenghe.developassistant.geometry.Point;

public class LngLatGeometryUtil {
    private static final double EARTH_RADIUS = 6378.137;

    public static double getDistance(Point point1, Point point2) {
        return LngLatGeometryUtil.getDistance(point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public static double getDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = LngLatGeometryUtil.rad(lat1);
        double radLat2 = LngLatGeometryUtil.rad(lat2);
        double a = LngLatGeometryUtil.rad(lat1) - LngLatGeometryUtil.rad(lat2);
        double b = LngLatGeometryUtil.rad(lng1) - LngLatGeometryUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s = s * 6378.137 * 1000.0;
        s = Math.round(s);
        return s;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }
}

