/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.geoscience;

import com.qishenghe.developassistant.exception.DevelopAssException;
import com.qishenghe.developassistant.geometry.Point;
import com.qishenghe.developassistant.geoscience.LngLatCoordinateEnum;

public class LngLatTranUtil {
    private static final double PI = Math.PI;
    private static double X_PI = 52.35987755982988;
    private static double A = 6378245.0;
    private static double EE = 0.006693421622965943;

    public static Point lngLatTrans(Point point, LngLatCoordinateEnum source, LngLatCoordinateEnum target) {
        Point targetPoint;
        Point gpsPoint;
        if (LngLatCoordinateEnum.COORDINATE_GCJ02 == source) {
            gpsPoint = LngLatTranUtil.gdToGps(point);
        } else if (LngLatCoordinateEnum.COORDINATE_BD09 == source) {
            gpsPoint = LngLatTranUtil.bdToGps(point);
        } else if (LngLatCoordinateEnum.COORDINATE_GPS == source) {
            gpsPoint = point;
        } else {
            throw new DevelopAssException(Point.class.getName() + " : cause : \u4e0d\u652f\u6301\u7684\u5750\u6807\u7cfb");
        }
        if (LngLatCoordinateEnum.COORDINATE_GCJ02 == target) {
            targetPoint = LngLatTranUtil.gpsToGd(gpsPoint);
        } else if (LngLatCoordinateEnum.COORDINATE_BD09 == target) {
            targetPoint = LngLatTranUtil.gpsToBd(gpsPoint);
        } else if (LngLatCoordinateEnum.COORDINATE_GPS == source) {
            targetPoint = gpsPoint;
        } else {
            throw new DevelopAssException(Point.class.getName() + " : cause : \u4e0d\u652f\u6301\u7684\u5750\u6807\u7cfb");
        }
        return targetPoint;
    }

    private static Point bdToGps(Point point) {
        double lat = point.getX();
        double lng = point.getY();
        double[] latLng = LngLatTranUtil.bd09ToGps84(lat, lng);
        return new Point(latLng[1], latLng[0]);
    }

    private static Point gdToGps(Point point) {
        double lat = point.getX();
        double lng = point.getY();
        double[] latLng = LngLatTranUtil.gcj02ToGps84(lat, lng);
        return new Point(latLng[1], latLng[0]);
    }

    private static Point gpsToBd(Point point) {
        double lat = point.getX();
        double lng = point.getY();
        double[] latLng = LngLatTranUtil.gps84ToBd09(lat, lng);
        return new Point(latLng[1], latLng[0]);
    }

    private static Point gpsToGd(Point point) {
        double lat = point.getX();
        double lng = point.getY();
        double[] latLng = LngLatTranUtil.gps84ToGcj02(lat, lng);
        return new Point(latLng[1], latLng[0]);
    }

    private static double[] gps84ToGcj02(double lat, double lon) {
        if (LngLatTranUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = LngLatTranUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = LngLatTranUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (A * (1.0 - EE) / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (A / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    private static double[] gcj02ToGps84(double lat, double lon) {
        double[] gps = LngLatTranUtil.transform(lat, lon);
        double lontitude = lon * 2.0 - gps[1];
        double latitude = lat * 2.0 - gps[0];
        return new double[]{latitude, lontitude};
    }

    private static double[] gcj02ToBd09(double lat, double lon) {
        double z = Math.sqrt(lon * lon + lat * lat) + 2.0E-5 * Math.sin(lat * X_PI);
        double theta = Math.atan2(lat, lon) + 3.0E-6 * Math.cos(lon * X_PI);
        double tempLon = z * Math.cos(theta) + 0.0065;
        double tempLat = z * Math.sin(theta) + 0.006;
        return new double[]{tempLat, tempLon};
    }

    private static double[] bd09ToGcj02(double lat, double lon) {
        double x = lon - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * X_PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * X_PI);
        double tempLon = z * Math.cos(theta);
        double tempLat = z * Math.sin(theta);
        return new double[]{tempLat, tempLon};
    }

    private static double[] gps84ToBd09(double lat, double lon) {
        double[] gcj02 = LngLatTranUtil.gps84ToGcj02(lat, lon);
        return LngLatTranUtil.gcj02ToBd09(gcj02[0], gcj02[1]);
    }

    private static double[] bd09ToGps84(double lat, double lon) {
        double[] gcj02 = LngLatTranUtil.bd09ToGcj02(lat, lon);
        return LngLatTranUtil.gcj02ToGps84(gcj02[0], gcj02[1]);
    }

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * Math.PI) + 40.0 * Math.sin(y / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * Math.PI) + 320.0 * Math.sin(y * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * Math.PI) + 20.0 * Math.sin(2.0 * x * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * Math.PI) + 40.0 * Math.sin(x / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * Math.PI) + 300.0 * Math.sin(x / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    private static double[] transform(double lat, double lon) {
        if (LngLatTranUtil.outOfChina(lat, lon)) {
            return new double[]{lat, lon};
        }
        double dLat = LngLatTranUtil.transformLat(lon - 105.0, lat - 35.0);
        double dLon = LngLatTranUtil.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (A * (1.0 - EE) / (magic * sqrtMagic) * Math.PI);
        dLon = dLon * 180.0 / (A / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    private static boolean outOfChina(double lat, double lon) {
        double chinaMinLng = 72.004;
        double chinaMaxLng = 137.8347;
        double chinaMinLat = 0.8293;
        double chinaMaxLat = 55.8271;
        boolean flag = false;
        if (lon < chinaMinLng || lon > chinaMaxLng) {
            flag = true;
        }
        if (lat < chinaMinLat || lat > chinaMaxLat) {
            flag = true;
        }
        return flag;
    }
}

