/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.io;

import com.qishenghe.developassistant.exception.DevelopAssException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private Charset charset;

    public FileUtil() {
        this.charset = Charset.forName(DEFAULT_CHARSET_NAME);
    }

    public FileUtil(Charset charset) {
        this.charset = charset;
    }

    public List<String> readFileList(String path) {
        ArrayList<String> lineList = new ArrayList<String>();
        try (InputStreamReader isReader = new InputStreamReader((InputStream)new FileInputStream(path), this.charset);
             BufferedReader br = new BufferedReader(isReader);){
            String tempString;
            while ((tempString = br.readLine()) != null && !"".equals(tempString)) {
                lineList.add(tempString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : " + e.getMessage());
        }
        return lineList;
    }

    public InputStream readFileStream(String path) {
        try {
            File file = new File(path);
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : " + e.getMessage());
        }
    }

    public byte[] readFileBytes(String path) {
        File file = new File(path);
        byte[] bytes = null;
        FileInputStream fis = null;
        ByteArrayOutputStream baoStream = null;
        try {
            int len;
            fis = new FileInputStream(file);
            baoStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                baoStream.write(buffer, 0, len);
            }
            bytes = baoStream.toByteArray();
            fis.close();
            baoStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : " + e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (baoStream != null) {
                    baoStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    private boolean writeFileList(List<String> list, String path) {
        boolean flag = false;
        if (list == null || list.size() == 0) {
            return false;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                flag = file.delete();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(path));
            for (String point : list) {
                bw.write(point + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : " + e.getMessage());
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFileStream(InputStream stream, String path) {
        boolean flag;
        File file = new File(path);
        FileOutputStream out = null;
        try {
            int n;
            out = new FileOutputStream(file);
            byte[] bb = new byte[1024];
            while ((n = stream.read(bb)) != -1) {
                ((OutputStream)out).write(bb, 0, n);
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFileBytes(byte[] bytes, String path) {
        boolean flag;
        File file = new File(path);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(bytes);
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUtil)) {
            return false;
        }
        FileUtil other = (FileUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        return result;
    }

    public String toString() {
        return "FileUtil(charset=" + this.getCharset() + ")";
    }
}

