/*
 * Decompiled with CFR 0.152.
 */
package com.qishenghe.developassistant.net;

import com.qishenghe.developassistant.exception.DevelopAssException;
import com.qishenghe.developassistant.io.FileUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private Charset charset;
    private HttpClient httpClient;

    public HttpUtil() {
        this.charset = Charset.forName(DEFAULT_CHARSET_NAME);
        this.httpClient = HttpClients.createDefault();
    }

    public HttpUtil(Charset charset) {
        this.charset = charset;
        this.httpClient = HttpClients.createDefault();
    }

    public HttpUtil(Charset charset, HttpClient httpClient) {
        this.charset = charset;
        this.httpClient = httpClient;
    }

    public String get(URIBuilder uriBuilder, List<Header> headerList) {
        String result;
        try {
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            result = this.send((HttpRequestBase)httpGet, headerList);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : url\u6784\u5efa\u5f02\u5e38");
        }
        return result;
    }

    public String get(String host, int port, String path, List<NameValuePair> paramList, List<Header> headerList) {
        return this.get(this.buildUri(host, port, path, paramList), headerList);
    }

    public String get(String url, List<NameValuePair> paramList, List<Header> headerList) {
        return this.get(this.buildUri(url, paramList), headerList);
    }

    public String get(String url, List<Header> headerList) {
        return this.get(this.buildUri(url), headerList);
    }

    public String post(URIBuilder uriBuilder, List<Header> headerList) {
        String result;
        try {
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            result = this.send((HttpRequestBase)httpPost, headerList);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : url\u6784\u5efa\u5f02\u5e38");
        }
        return result;
    }

    public String post(String host, int port, String path, List<NameValuePair> paramList, List<Header> headerList) {
        return this.post(this.buildUri(host, port, path, paramList), headerList);
    }

    public String post(String url, List<NameValuePair> paramList, List<Header> headerList) {
        return this.post(this.buildUri(url, paramList), headerList);
    }

    public String post(String url, List<Header> headerList) {
        return this.post(this.buildUri(url), headerList);
    }

    private URIBuilder buildUri(String host, int port, String path, List<NameValuePair> paramList) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(host);
        uriBuilder.setPort(port);
        uriBuilder.setPath(path);
        uriBuilder.setCharset(this.charset);
        if (!CollectionUtils.isEmpty(paramList)) {
            uriBuilder.setParameters(paramList);
        }
        return uriBuilder;
    }

    private URIBuilder buildUri(String url, List<NameValuePair> paramList) {
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(url);
            uriBuilder.setCharset(this.charset);
            if (!CollectionUtils.isEmpty(paramList)) {
                uriBuilder.setParameters(paramList);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : \u81ea\u5b9a\u4e49url\u89e3\u6790\u5f02\u5e38");
        }
        return uriBuilder;
    }

    private URIBuilder buildUri(String url) {
        return this.buildUri(url, null);
    }

    private String send(HttpRequestBase httpRequestBase, List<Header> headerList) {
        String result;
        try {
            if (!CollectionUtils.isEmpty(headerList)) {
                httpRequestBase.setHeaders(headerList.toArray(new Header[0]));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)this.charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DevelopAssException(FileUtil.class.getName() + " : cause : Http\u8bf7\u6c42\u6267\u884c\u5f02\u5e38");
        }
        return result;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpUtil)) {
            return false;
        }
        HttpUtil other = (HttpUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        HttpClient this$httpClient = this.getHttpClient();
        HttpClient other$httpClient = other.getHttpClient();
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        HttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    public String toString() {
        return "HttpUtil(charset=" + this.getCharset() + ", httpClient=" + this.getHttpClient() + ")";
    }
}

