/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.admin.AutoloadCacheController;
import com.jarvis.cache.admin.HTTPBasicAuthorizeAttribute;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDelete;
import com.jarvis.cache.annotation.CacheDeleteTransactional;
import com.jarvis.cache.autoconfigure.AutoloadCacheManageConfiguration;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.autoconfigure.DistributedLockConfiguration;
import com.jarvis.cache.autoconfigure.MethodAnnotationPointcutAdvisor;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.interceptor.CacheDeleteInterceptor;
import com.jarvis.cache.interceptor.CacheDeleteTransactionalInterceptor;
import com.jarvis.cache.interceptor.CacheMethodInterceptor;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.serializer.ISerializer;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(name={"com.jarvis.cache.CacheHandler"})
@AutoConfigureAfter(value={AutoloadCacheManageConfiguration.class, DistributedLockConfiguration.class})
@ConditionalOnProperty(value={"autoload.cache.enable"}, matchIfMissing=true)
public class AutoloadCacheAutoConfigure {
    private static final String VALIDATOR_BEAN_NAME = "autoloadCacheAutoConfigurationValidator";
    @Autowired
    private AutoloadCacheProperties config;
    private final ILock lock;

    public AutoloadCacheAutoConfigure(ObjectProvider<ILock> lockProvider) {
        this.lock = null != lockProvider ? (ILock)lockProvider.getIfAvailable() : null;
    }

    @Bean(name={"autoloadCacheAutoConfigurationValidator"})
    public CacheManagerValidator autoloadCacheAutoConfigurationValidator() {
        return new CacheManagerValidator();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(value={CacheHandler.class})
    @ConditionalOnBean(value={ICacheManager.class, AbstractScriptParser.class, ICloner.class})
    public CacheHandler autoloadCacheHandler(ICacheManager cacheManager, AbstractScriptParser scriptParser, ICloner cloner) {
        CacheHandler cacheHandler = new CacheHandler(cacheManager, scriptParser, this.config.getConfig(), cloner);
        cacheHandler.setLock(this.lock);
        return cacheHandler;
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    @ConditionalOnProperty(value={"autoload.cache.enable-read-and-write"}, matchIfMissing=true)
    public CacheMethodInterceptor autoloadCacheMethodInterceptor(CacheHandler cacheHandler) {
        return new CacheMethodInterceptor(cacheHandler, this.config);
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    @ConditionalOnProperty(value={"autoload.cache.enable-delete"}, matchIfMissing=true)
    public CacheDeleteInterceptor autoloadCacheDeleteInterceptor(CacheHandler cacheHandler) {
        return new CacheDeleteInterceptor(cacheHandler, this.config);
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    @ConditionalOnProperty(value={"autoload.cache.enable-delete"}, matchIfMissing=true)
    public CacheDeleteTransactionalInterceptor autoloadCacheDeleteTransactionalInterceptor(CacheHandler cacheHandler) {
        return new CacheDeleteTransactionalInterceptor(cacheHandler, this.config);
    }

    @Bean(value={"autoloadCacheAdvisor"})
    @ConditionalOnBean(value={CacheMethodInterceptor.class})
    public AbstractPointcutAdvisor autoloadCacheAdvisor(CacheMethodInterceptor cacheMethodInterceptor) {
        MethodAnnotationPointcutAdvisor cacheAdvisor = new MethodAnnotationPointcutAdvisor(Cache.class, (Advice)cacheMethodInterceptor);
        cacheAdvisor.setOrder(this.config.getCacheOrder());
        return cacheAdvisor;
    }

    @Bean(value={"autoloadCacheDeleteAdvisor"})
    @ConditionalOnBean(value={CacheDeleteInterceptor.class})
    public AbstractPointcutAdvisor autoloadCacheDeleteAdvisor(CacheDeleteInterceptor cacheDeleteInterceptor) {
        MethodAnnotationPointcutAdvisor cacheDeleteAdvisor = new MethodAnnotationPointcutAdvisor(CacheDelete.class, (Advice)cacheDeleteInterceptor);
        cacheDeleteAdvisor.setOrder(this.config.getDeleteCacheOrder());
        return cacheDeleteAdvisor;
    }

    @Bean(value={"autoloadCacheDeleteTransactionalAdvisor"})
    @ConditionalOnBean(value={CacheDeleteTransactionalInterceptor.class})
    public AbstractPointcutAdvisor autoloadCacheDeleteTransactionalAdvisor(CacheDeleteTransactionalInterceptor cacheDeleteTransactionalInterceptor) {
        MethodAnnotationPointcutAdvisor cacheDeleteTransactionalAdvisor = new MethodAnnotationPointcutAdvisor(CacheDeleteTransactional.class, (Advice)cacheDeleteTransactionalInterceptor);
        cacheDeleteTransactionalAdvisor.setOrder(this.config.getDeleteCacheTransactionalOrder());
        return cacheDeleteTransactionalAdvisor;
    }

    @Bean
    @ConditionalOnBean(value={CacheHandler.class})
    public AbstractAdvisorAutoProxyCreator autoloadCacheAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxy = new DefaultAdvisorAutoProxyCreator();
        proxy.setAdvisorBeanNamePrefix("autoloadCache");
        proxy.setProxyTargetClass(this.config.isProxyTargetClass());
        return proxy;
    }

    @Bean
    @ConditionalOnWebApplication
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        HTTPBasicAuthorizeAttribute httpBasicFilter = new HTTPBasicAuthorizeAttribute(this.config);
        registrationBean.setFilter((Filter)httpBasicFilter);
        ArrayList<String> urlPatterns = new ArrayList<String>();
        urlPatterns.add("/autoload-cache-ui.html");
        urlPatterns.add("/autoload-cache/*");
        registrationBean.setUrlPatterns(urlPatterns);
        return registrationBean;
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean(value={AutoloadCacheController.class})
    public AutoloadCacheController AutoloadCacheController(CacheHandler autoloadCacheHandler) {
        return new AutoloadCacheController(autoloadCacheHandler);
    }

    static class CacheManagerValidator {
        @Autowired(required=false)
        private AbstractScriptParser scriptParser;
        @Autowired(required=false)
        private ISerializer<Object> serializer;
        @Autowired(required=false)
        private ICacheManager cacheManager;

        CacheManagerValidator() {
        }

        @PostConstruct
        public void checkHasCacheManager() {
            Assert.notNull((Object)this.scriptParser, (String)"No script parser could be auto-configured");
            Assert.notNull(this.serializer, (String)"No serializer could be auto-configured");
            Assert.notNull((Object)this.cacheManager, (String)"No cache manager could be auto-configured");
        }
    }
}

