/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.autoconfigure;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.redis.JedisClusterCacheManager;
import com.jarvis.cache.redis.LettuceRedisClusterCacheManager;
import com.jarvis.cache.redis.SpringRedisCacheManager;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.script.SpringELParser;
import com.jarvis.cache.serializer.HessianSerializer;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.JdkSerializer;
import com.jarvis.cache.serializer.KryoSerializer;
import io.lettuce.core.RedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

@Configuration
@ConditionalOnClass(name={"com.jarvis.cache.ICacheManager"})
@EnableConfigurationProperties(value={AutoloadCacheProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnProperty(value={"autoload.cache.enable"}, matchIfMissing=true)
public class AutoloadCacheManageConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AutoloadCacheManageConfiguration.class);
    private static final boolean hessianPresent = ClassUtils.isPresent((String)"com.caucho.hessian.io.AbstractSerializerFactory", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());
    private static final boolean kryoPresent = ClassUtils.isPresent((String)"com.esotericsoftware.kryo.Kryo", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());

    @Bean
    @ConditionalOnMissingBean(value={AbstractScriptParser.class})
    public AbstractScriptParser autoloadCacheScriptParser() {
        return new SpringELParser();
    }

    @Bean
    @ConditionalOnMissingBean(value={ISerializer.class})
    public ISerializer<Object> autoloadCacheSerializer() {
        HessianSerializer res;
        if (hessianPresent) {
            res = new HessianSerializer();
            log.debug("HessianSerializer auto-configured");
        } else if (kryoPresent) {
            res = new KryoSerializer();
            log.debug("KryoSerializer auto-configured");
        } else {
            res = new JdkSerializer();
            log.debug("JdkSerializer auto-configured");
        }
        return res;
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class})
    static class LettuceCacheCacheManagerConfiguration {
        LettuceCacheCacheManagerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ICacheManager.class})
        @ConditionalOnBean(value={LettuceConnectionFactory.class})
        public ICacheManager autoloadCacheCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, LettuceConnectionFactory connectionFactory) {
            return this.createRedisCacheManager(config, serializer, connectionFactory);
        }

        private ICacheManager createRedisCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, LettuceConnectionFactory connectionFactory) {
            RedisConnection redisConnection = null;
            try {
                redisConnection = connectionFactory.getConnection();
                SpringRedisCacheManager cacheManager = null;
                if (redisConnection instanceof LettuceClusterConnection) {
                    LettuceClusterConnection lettuceClusterConnection = (LettuceClusterConnection)redisConnection;
                    try {
                        Field clusterClientField = LettuceClusterConnection.class.getDeclaredField("clusterClient");
                        clusterClientField.setAccessible(true);
                        RedisClusterClient redisClusterClient = (RedisClusterClient)clusterClientField.get(lettuceClusterConnection);
                        cacheManager = new LettuceRedisClusterCacheManager(redisClusterClient, serializer);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    cacheManager = new SpringRedisCacheManager((RedisConnectionFactory)connectionFactory, serializer);
                }
                cacheManager.setHashExpire(config.getJedis().getHashExpire());
                SpringRedisCacheManager springRedisCacheManager = cacheManager;
                return springRedisCacheManager;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                throw e;
            }
            finally {
                RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)connectionFactory);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Jedis.class})
    static class JedisCacheCacheManagerConfiguration {
        JedisCacheCacheManagerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ICacheManager.class})
        @ConditionalOnBean(value={JedisConnectionFactory.class})
        public ICacheManager autoloadCacheCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, JedisConnectionFactory connectionFactory) {
            return this.createRedisCacheManager(config, serializer, connectionFactory);
        }

        private ICacheManager createRedisCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, JedisConnectionFactory connectionFactory) {
            RedisConnection redisConnection = null;
            try {
                redisConnection = connectionFactory.getConnection();
                SpringRedisCacheManager cacheManager = null;
                if (redisConnection instanceof JedisClusterConnection) {
                    JedisClusterConnection redisClusterConnection = (JedisClusterConnection)redisConnection;
                    JedisCluster jedisCluster = redisClusterConnection.getNativeConnection();
                    cacheManager = new JedisClusterCacheManager(jedisCluster, serializer);
                } else {
                    cacheManager = new SpringRedisCacheManager((RedisConnectionFactory)connectionFactory, serializer);
                }
                cacheManager.setHashExpire(config.getJedis().getHashExpire());
                SpringRedisCacheManager springRedisCacheManager = cacheManager;
                return springRedisCacheManager;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                throw e;
            }
            finally {
                RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)connectionFactory);
            }
        }
    }
}

