/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.DataLoaderFactory;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLoadHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoLoadHandler.class);
    public static final int AUTO_LOAD_MIN_EXPIRE = 120;
    private static final int ONE_THOUSAND_MS = 1000;
    public static final String THREAD_NAME_PREFIX = "autoLoadThread-";
    private final ConcurrentHashMap<CacheKeyTO, AutoLoadTO> autoLoadMap;
    private final CacheHandler cacheHandler;
    private final Thread[] threads;
    private final Thread sortThread;
    private final LinkedBlockingQueue<AutoLoadTO> autoLoadQueue;
    private volatile boolean running = false;
    private final AutoLoadConfig config;

    public AutoLoadHandler(CacheHandler cacheHandler, AutoLoadConfig config) {
        this.cacheHandler = cacheHandler;
        this.config = config;
        if (this.config.getThreadCnt() > 0) {
            this.running = true;
            this.threads = new Thread[this.config.getThreadCnt()];
            this.autoLoadMap = new ConcurrentHashMap(this.config.getMaxElement());
            this.autoLoadQueue = new LinkedBlockingQueue(this.config.getMaxElement());
            this.sortThread = new Thread(new SortRunnable());
            this.sortThread.setDaemon(true);
            this.sortThread.start();
            for (int i = 0; i < this.config.getThreadCnt(); ++i) {
                this.threads[i] = new Thread(new AutoLoadRunnable());
                this.threads[i].setName(THREAD_NAME_PREFIX + i);
                this.threads[i].setDaemon(true);
                this.threads[i].start();
            }
        } else {
            this.threads = null;
            this.autoLoadMap = null;
            this.autoLoadQueue = null;
            this.sortThread = null;
        }
    }

    public int getSize() {
        if (null != this.autoLoadMap) {
            return this.autoLoadMap.size();
        }
        if (null != this.sortThread) {
            this.sortThread.interrupt();
        }
        if (null != this.threads || this.threads.length > 0) {
            for (Thread thread : this.threads) {
                thread.interrupt();
            }
        }
        return -1;
    }

    public AutoLoadTO getAutoLoadTO(CacheKeyTO cacheKey) {
        if (null == this.autoLoadMap) {
            return null;
        }
        return this.autoLoadMap.get(cacheKey);
    }

    public void removeAutoLoadTO(CacheKeyTO cacheKey) {
        if (null == this.autoLoadMap) {
            return;
        }
        this.autoLoadMap.remove(cacheKey);
    }

    public void resetAutoLoadLastLoadTime(CacheKeyTO cacheKey) {
        if (null == this.autoLoadMap) {
            return;
        }
        AutoLoadTO autoLoadTO = this.autoLoadMap.get(cacheKey);
        if (null != autoLoadTO && !autoLoadTO.isLoading()) {
            autoLoadTO.setLastLoadTime(1L);
        }
    }

    public void shutdown() {
        this.running = false;
        if (null != this.autoLoadMap) {
            this.autoLoadMap.clear();
        }
        log.info("----------------------AutoLoadHandler.shutdown--------------------");
    }

    public AutoLoadTO putIfAbsent(CacheKeyTO cacheKey, CacheAopProxyChain joinPoint, Cache cache, CacheWrapper<Object> cacheWrapper) {
        if (null == this.autoLoadMap) {
            return null;
        }
        AutoLoadTO autoLoadTO = this.autoLoadMap.get(cacheKey);
        if (null != autoLoadTO) {
            return autoLoadTO;
        }
        try {
            if (!this.cacheHandler.getScriptParser().isAutoload(cache, joinPoint.getTarget(), joinPoint.getArgs(), cacheWrapper.getCacheObject())) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        int expire = cacheWrapper.getExpire();
        if (expire >= 120 && this.autoLoadMap.size() <= this.config.getMaxElement()) {
            Object[] arguments;
            if (cache.argumentsDeepcloneEnable()) {
                try {
                    arguments = this.cacheHandler.getCloner().deepCloneMethodArgs(joinPoint.getMethod(), joinPoint.getArgs());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            } else {
                arguments = joinPoint.getArgs();
            }
            autoLoadTO = new AutoLoadTO(cacheKey, joinPoint, arguments, cache, expire);
            AutoLoadTO tmp = this.autoLoadMap.putIfAbsent(cacheKey, autoLoadTO);
            if (null == tmp) {
                return autoLoadTO;
            }
            return tmp;
        }
        return null;
    }

    private void writeCacheAndSetLoadTime(Cache cache, CacheAopProxyChain pjp, CacheKeyTO cacheKey, CacheWrapper<Object> newCacheWrapper, long loadDataUseTime, AutoLoadTO autoLoadTO) {
        try {
            if (null != newCacheWrapper) {
                this.cacheHandler.writeCache(pjp, autoLoadTO.getArgs(), cache, cacheKey, newCacheWrapper);
                autoLoadTO.setLastLoadTime(newCacheWrapper.getLastLoadTime()).setExpire(newCacheWrapper.getExpire()).addUseTotalTime(loadDataUseTime);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public AutoLoadTO[] getAutoLoadQueue() {
        if (null == this.autoLoadMap || this.autoLoadMap.isEmpty()) {
            return null;
        }
        AutoLoadTO[] tmpArr = new AutoLoadTO[this.autoLoadMap.size()];
        tmpArr = this.autoLoadMap.values().toArray(tmpArr);
        if (null != this.config.getSortType() && null != this.config.getSortType().getComparator()) {
            Arrays.sort(tmpArr, this.config.getSortType().getComparator());
        }
        return tmpArr;
    }

    class AutoLoadRunnable
    implements Runnable {
        AutoLoadRunnable() {
        }

        @Override
        public void run() {
            while (AutoLoadHandler.this.running) {
                try {
                    AutoLoadTO tmpTO = (AutoLoadTO)AutoLoadHandler.this.autoLoadQueue.take();
                    if (null == tmpTO) continue;
                    this.loadCache(tmpTO);
                    Thread.sleep(AutoLoadHandler.this.config.getAutoLoadPeriod());
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCache(AutoLoadTO autoLoadTO) {
            DataLoader dataLoader;
            if (null == autoLoadTO) {
                return;
            }
            long now = System.currentTimeMillis();
            if (autoLoadTO.getLastRequestTime() <= 0L || autoLoadTO.getLastLoadTime() <= 0L) {
                return;
            }
            Cache cache = autoLoadTO.getCache();
            long requestTimeout = cache.requestTimeout();
            boolean alwaysCache = cache.alwaysCache();
            if (!alwaysCache && requestTimeout > 0L && now - autoLoadTO.getLastRequestTime() >= requestTimeout * 1000L) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            if (!alwaysCache && autoLoadTO.getLoadCnt() > 100L && autoLoadTO.getAverageUseTime() < (long)AutoLoadHandler.this.config.getLoadUseTimeForAutoLoad1()) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            long difFirstRequestTime = now - autoLoadTO.getFirstRequestTime();
            long oneHourSecs = 3600000L;
            if (!alwaysCache && difFirstRequestTime > oneHourSecs && autoLoadTO.getAverageUseTime() < (long)AutoLoadHandler.this.config.getLoadUseTimeForAutoLoad2() && autoLoadTO.getRequestTimes() / (difFirstRequestTime / oneHourSecs) < 60L) {
                AutoLoadHandler.this.autoLoadMap.remove(autoLoadTO.getCacheKey());
                return;
            }
            if (autoLoadTO.isLoading()) {
                return;
            }
            int expire = autoLoadTO.getExpire();
            if (!alwaysCache && expire < 120) {
                return;
            }
            int alarmTime = autoLoadTO.getCache().alarmTime();
            long timeout = alarmTime > 0 && alarmTime < expire ? (long)(expire - alarmTime) : (expire >= 600 ? (long)(expire - 120) : (long)(expire - 60));
            int rand = ThreadLocalRandom.current().nextInt(10);
            timeout = (timeout + (long)(rand % 2 == 0 ? rand : -rand)) * 1000L;
            if (now - autoLoadTO.getLastLoadTime() < timeout) {
                return;
            }
            CacheWrapper<Object> result = null;
            if (AutoLoadHandler.this.config.isCheckFromCacheBeforeLoad()) {
                try {
                    Method method = autoLoadTO.getJoinPoint().getMethod();
                    result = AutoLoadHandler.this.cacheHandler.get(autoLoadTO.getCacheKey(), method);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                if (null != result) {
                    autoLoadTO.setExpire(result.getExpire());
                    if (result.getLastLoadTime() > autoLoadTO.getLastLoadTime() && now - result.getLastLoadTime() < timeout) {
                        autoLoadTO.setLastLoadTime(result.getLastLoadTime());
                        return;
                    }
                }
            }
            CacheAopProxyChain pjp = autoLoadTO.getJoinPoint();
            CacheKeyTO cacheKey = autoLoadTO.getCacheKey();
            if (AutoLoadHandler.this.config.isDataLoaderPooled()) {
                DataLoaderFactory factory = DataLoaderFactory.getInstance();
                dataLoader = factory.getDataLoader();
            } else {
                dataLoader = new DataLoader();
            }
            CacheWrapper<Object> newCacheWrapper = null;
            boolean isFirst = false;
            long loadDataUseTime = 0L;
            try {
                newCacheWrapper = dataLoader.init(pjp, autoLoadTO, cacheKey, cache, AutoLoadHandler.this.cacheHandler).loadData().getCacheWrapper();
                loadDataUseTime = dataLoader.getLoadDataUseTime();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                isFirst = dataLoader.isFirst();
                if (AutoLoadHandler.this.config.isDataLoaderPooled()) {
                    DataLoaderFactory factory = DataLoaderFactory.getInstance();
                    factory.returnObject(dataLoader);
                }
            }
            if (isFirst) {
                if (null == newCacheWrapper && null != result) {
                    int newExpire = !alwaysCache ? 180 : cache.expire();
                    newCacheWrapper = new CacheWrapper<Object>(result.getCacheObject(), newExpire);
                }
                AutoLoadHandler.this.writeCacheAndSetLoadTime(cache, pjp, cacheKey, newCacheWrapper, loadDataUseTime, autoLoadTO);
            }
        }
    }

    class SortRunnable
    implements Runnable {
        SortRunnable() {
        }

        @Override
        public void run() {
            while (AutoLoadHandler.this.running) {
                AutoLoadTO[] tmpArr;
                int sleep = 100;
                if (AutoLoadHandler.this.autoLoadMap.isEmpty() || AutoLoadHandler.this.autoLoadQueue.size() > 0) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (AutoLoadHandler.this.autoLoadMap.size() <= AutoLoadHandler.this.threads.length * 10) {
                    sleep = 1000;
                } else if (AutoLoadHandler.this.autoLoadMap.size() <= AutoLoadHandler.this.threads.length * 50) {
                    sleep = 300;
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (null == (tmpArr = AutoLoadHandler.this.getAutoLoadQueue()) || tmpArr.length == 0) continue;
                for (int i = 0; i < tmpArr.length; ++i) {
                    try {
                        AutoLoadTO to = tmpArr[i];
                        AutoLoadHandler.this.autoLoadQueue.put(to);
                        if (i <= 0 || i % 1000 != 0) continue;
                        Thread.yield();
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

