/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.AutoLoadHandler;
import com.jarvis.cache.CacheHelper;
import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.ChangeListener;
import com.jarvis.cache.DataLoader;
import com.jarvis.cache.DataLoaderFactory;
import com.jarvis.cache.DeleteCacheMagicHandler;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.MagicHandler;
import com.jarvis.cache.RefreshHandler;
import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDelete;
import com.jarvis.cache.annotation.CacheDeleteKey;
import com.jarvis.cache.annotation.CacheDeleteMagicKey;
import com.jarvis.cache.annotation.CacheDeleteTransactional;
import com.jarvis.cache.annotation.ExCache;
import com.jarvis.cache.aop.CacheAopProxyChain;
import com.jarvis.cache.aop.DeleteCacheAopProxyChain;
import com.jarvis.cache.aop.DeleteCacheTransactionalAopProxyChain;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.AutoLoadTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import com.jarvis.cache.to.ProcessingTO;
import com.jarvis.cache.type.CacheOpType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler {
    private static final Logger log = LoggerFactory.getLogger(CacheHandler.class);
    public final ConcurrentHashMap<CacheKeyTO, ProcessingTO> processing;
    private final ICacheManager cacheManager;
    private final AutoLoadConfig config;
    private final ICloner cloner;
    private final AutoLoadHandler autoLoadHandler;
    private final AbstractScriptParser scriptParser;
    private final RefreshHandler refreshHandler;
    private ILock lock;
    private ChangeListener changeListener;

    public CacheHandler(ICacheManager cacheManager, AbstractScriptParser scriptParser, AutoLoadConfig config, ICloner cloner) {
        this.processing = new ConcurrentHashMap(config.getProcessingMapSize());
        this.cacheManager = cacheManager;
        this.config = config;
        this.cloner = cloner;
        this.autoLoadHandler = new AutoLoadHandler(this, config);
        this.scriptParser = scriptParser;
        this.registerFunction(config.getFunctions());
        this.refreshHandler = new RefreshHandler(this, config);
    }

    private Object writeOnly(CacheAopProxyChain pjp, Cache cache) throws Throwable {
        CacheWrapper<Object> cacheWrapper;
        DataLoader dataLoader;
        if (this.config.isDataLoaderPooled()) {
            DataLoaderFactory factory = DataLoaderFactory.getInstance();
            dataLoader = factory.getDataLoader();
        } else {
            dataLoader = new DataLoader();
        }
        try {
            cacheWrapper = dataLoader.init(pjp, cache, this).getData().getCacheWrapper();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.config.isDataLoaderPooled()) {
                DataLoaderFactory factory = DataLoaderFactory.getInstance();
                factory.returnObject(dataLoader);
            }
        }
        Object result = cacheWrapper.getCacheObject();
        Object[] arguments = pjp.getArgs();
        if (this.scriptParser.isCacheable(cache, pjp.getTarget(), arguments, result)) {
            CacheKeyTO cacheKey = this.getCacheKey(pjp, cache, result);
            AutoLoadTO autoLoadTO = this.autoLoadHandler.getAutoLoadTO(cacheKey);
            try {
                this.writeCache(pjp, pjp.getArgs(), cache, cacheKey, cacheWrapper);
                if (null != autoLoadTO) {
                    autoLoadTO.setLastLoadTime(cacheWrapper.getLastLoadTime()).setExpire(cacheWrapper.getExpire());
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    private CacheOpType getCacheOpType(Cache cache, Object[] arguments) {
        CacheOpType opType = cache.opType();
        CacheOpType tmpOpType = CacheHelper.getCacheOpType();
        if (null != tmpOpType) {
            opType = tmpOpType;
        }
        if (null != arguments && arguments.length > 0) {
            for (Object tmp : arguments) {
                if (null == tmp || !(tmp instanceof CacheOpType)) continue;
                opType = (CacheOpType)((Object)tmp);
                break;
            }
        }
        if (null == opType) {
            opType = CacheOpType.READ_WRITE;
        }
        return opType;
    }

    public Object proceed(CacheAopProxyChain pjp, Cache cache) throws Throwable {
        boolean isFirst;
        DataLoader dataLoader;
        Object[] arguments = pjp.getArgs();
        CacheOpType opType = this.getCacheOpType(cache, arguments);
        if (log.isTraceEnabled()) {
            log.trace("CacheHandler.proceed-->{}.{}--{})", new Object[]{pjp.getTarget().getClass().getName(), pjp.getMethod().getName(), opType.name()});
        }
        if (opType == CacheOpType.WRITE) {
            return this.writeOnly(pjp, cache);
        }
        if (opType == CacheOpType.LOAD || !this.scriptParser.isCacheable(cache, pjp.getTarget(), arguments)) {
            return this.getData(pjp);
        }
        Method method = pjp.getMethod();
        if (MagicHandler.isMagic(cache, method)) {
            return new MagicHandler(this, pjp, cache).magic();
        }
        CacheKeyTO cacheKey = this.getCacheKey(pjp, cache);
        if (null == cacheKey) {
            return this.getData(pjp);
        }
        CacheWrapper<Object> cacheWrapper = null;
        try {
            cacheWrapper = this.get(cacheKey, method);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        if (log.isTraceEnabled()) {
            log.trace("cache key:{}, cache data is {} ", (Object)cacheKey.getCacheKey(), cacheWrapper);
        }
        if (opType == CacheOpType.READ_ONLY) {
            return null == cacheWrapper ? null : cacheWrapper.getCacheObject();
        }
        if (null != cacheWrapper && !cacheWrapper.isExpired()) {
            AutoLoadTO autoLoadTO = this.autoLoadHandler.putIfAbsent(cacheKey, pjp, cache, cacheWrapper);
            if (null != autoLoadTO) {
                autoLoadTO.flushRequestTime(cacheWrapper);
            } else {
                this.refreshHandler.doRefresh(pjp, cache, cacheKey, cacheWrapper);
            }
            return cacheWrapper.getCacheObject();
        }
        if (this.config.isDataLoaderPooled()) {
            DataLoaderFactory factory = DataLoaderFactory.getInstance();
            dataLoader = factory.getDataLoader();
        } else {
            dataLoader = new DataLoader();
        }
        CacheWrapper<Object> newCacheWrapper = null;
        long loadDataUseTime = 0L;
        try {
            newCacheWrapper = dataLoader.init(pjp, cacheKey, cache, this).loadData().getCacheWrapper();
            loadDataUseTime = dataLoader.getLoadDataUseTime();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            isFirst = dataLoader.isFirst();
            if (this.config.isDataLoaderPooled()) {
                DataLoaderFactory factory = DataLoaderFactory.getInstance();
                factory.returnObject(dataLoader);
            }
        }
        if (isFirst) {
            AutoLoadTO autoLoadTO = this.autoLoadHandler.putIfAbsent(cacheKey, pjp, cache, newCacheWrapper);
            try {
                this.writeCache(pjp, pjp.getArgs(), cache, cacheKey, newCacheWrapper);
                if (null != autoLoadTO) {
                    autoLoadTO.flushRequestTime(newCacheWrapper);
                    autoLoadTO.addUseTotalTime(loadDataUseTime);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return newCacheWrapper.getCacheObject();
    }

    public void deleteCache(DeleteCacheAopProxyChain jp, CacheDelete cacheDelete, Object retVal) throws Throwable {
        Object[] arguments = jp.getArgs();
        CacheDeleteKey[] keys = cacheDelete.value();
        CacheDeleteMagicKey[] magicKeys = cacheDelete.magic();
        Object target = jp.getTarget();
        String methodName = jp.getMethod().getName();
        try {
            DeleteCacheMagicHandler magicHandler;
            List<List<CacheKeyTO>> lists;
            boolean isOnTransactional = CacheHelper.isOnTransactional();
            HashSet<CacheKeyTO> keySet = null;
            if (!isOnTransactional) {
                keySet = new HashSet<CacheKeyTO>(keys.length);
            }
            if (null != magicKeys && magicKeys.length > 0 && null != (lists = (magicHandler = new DeleteCacheMagicHandler(this, jp, magicKeys, retVal)).getCacheKeyForMagic()) && !lists.isEmpty()) {
                for (List<CacheKeyTO> list : lists) {
                    for (CacheKeyTO key : list) {
                        if (null == key) continue;
                        if (isOnTransactional) {
                            CacheHelper.addDeleteCacheKey(key);
                        } else {
                            keySet.add(key);
                        }
                        this.getAutoLoadHandler().resetAutoLoadLastLoadTime(key);
                    }
                }
            }
            if (null != keys && keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    CacheDeleteKey keyConfig = keys[i];
                    if (!this.scriptParser.isCanDelete(keyConfig, arguments, retVal)) continue;
                    String[] tempKeys = keyConfig.value();
                    String tempHfield = keyConfig.hfield();
                    for (String tempKey : tempKeys) {
                        CacheKeyTO key = this.getCacheKey(target, methodName, arguments, tempKey, tempHfield, retVal, true);
                        if (null == key) continue;
                        if (isOnTransactional) {
                            CacheHelper.addDeleteCacheKey(key);
                        } else {
                            keySet.add(key);
                        }
                        this.getAutoLoadHandler().resetAutoLoadLastLoadTime(key);
                    }
                }
            }
            this.delete(keySet);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    public Object proceedDeleteCacheTransactional(DeleteCacheTransactionalAopProxyChain pjp, CacheDeleteTransactional cacheDeleteTransactional) throws Throwable {
        boolean isStart;
        Object result = null;
        Set<CacheKeyTO> set0 = CacheHelper.getDeleteCacheKeysSet();
        boolean bl = isStart = null == set0;
        if (!cacheDeleteTransactional.useCache()) {
            CacheHelper.setCacheOpType(CacheOpType.LOAD);
        }
        boolean getError = false;
        try {
            CacheHelper.initDeleteCacheKeysSet();
            result = pjp.doProxyChain();
        }
        catch (Throwable e) {
            getError = true;
            throw e;
        }
        finally {
            CacheHelper.clearCacheOpType();
            if (isStart && (!getError || cacheDeleteTransactional.deleteCacheOnError())) {
                this.clearCache();
            }
        }
        return result;
    }

    private void clearCache() throws Throwable {
        try {
            Set<CacheKeyTO> set = CacheHelper.getDeleteCacheKeysSet();
            if (null != set && set.size() > 0) {
                this.delete(set);
            } else if (log.isWarnEnabled()) {
                log.warn("proceedDeleteCacheTransactional: key set is empty!");
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw e;
        }
        finally {
            CacheHelper.clearDeleteCacheKeysSet();
        }
    }

    private Object getData(CacheAopProxyChain pjp) throws Throwable {
        return this.getData(pjp, pjp.getArgs());
    }

    public Object getData(CacheAopProxyChain pjp, Object[] arguments) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = pjp.doProxyChain(arguments);
        long useTime = System.currentTimeMillis() - startTime;
        if (this.config.isPrintSlowLog() && useTime >= (long)this.config.getSlowLoadTime()) {
            String className = pjp.getTarget().getClass().getName();
            if (log.isWarnEnabled()) {
                log.warn("{}.{}, use time:{}ms", new Object[]{className, pjp.getMethod().getName(), useTime});
            }
        }
        return result;
    }

    public void writeCache(CacheAopProxyChain pjp, Object[] arguments, Cache cache, CacheKeyTO cacheKey, CacheWrapper<Object> cacheWrapper) throws Exception {
        if (null == cacheKey) {
            return;
        }
        ExCache[] exCaches = cache.exCache();
        Method method = pjp.getMethod();
        ArrayList<MSetParam> params = new ArrayList<MSetParam>(exCaches.length + 1);
        if (cacheWrapper.getExpire() >= 0) {
            params.add(new MSetParam(cacheKey, cacheWrapper));
        }
        Object result = cacheWrapper.getCacheObject();
        Object target = pjp.getTarget();
        for (ExCache exCache : exCaches) {
            try {
                CacheKeyTO exCacheKey;
                if (!this.scriptParser.isCacheable(exCache, pjp.getTarget(), arguments, result) || null == (exCacheKey = this.getCacheKey(pjp, arguments, exCache, result))) continue;
                Object exResult = null;
                exResult = null == exCache.cacheObject() || exCache.cacheObject().isEmpty() ? result : this.scriptParser.getElValue(exCache.cacheObject(), target, arguments, result, true, Object.class);
                int exCacheExpire = this.scriptParser.getRealExpire(exCache.expire(), exCache.expireExpression(), arguments, exResult);
                CacheWrapper<Object> exCacheWrapper = new CacheWrapper<Object>(exResult, exCacheExpire);
                AutoLoadTO tmpAutoLoadTO = this.autoLoadHandler.getAutoLoadTO(exCacheKey);
                if (exCacheExpire < 0) continue;
                params.add(new MSetParam(exCacheKey, exCacheWrapper));
                if (null == tmpAutoLoadTO) continue;
                tmpAutoLoadTO.setExpire(exCacheExpire).setLastLoadTime(exCacheWrapper.getLastLoadTime());
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        int size = params.size();
        if (size == 1) {
            MSetParam param = (MSetParam)params.get(0);
            this.setCache(param.getCacheKey(), param.getResult(), method);
        } else if (size > 1) {
            this.mset(method, params);
        }
    }

    public void destroy() {
        this.autoLoadHandler.shutdown();
        this.refreshHandler.shutdown();
        log.trace("cache destroy ... ... ...");
    }

    public CacheKeyTO getCacheKey(Object target, String methodName, Object[] arguments, String keyExpression, String hfieldExpression, Object result, boolean hasRetVal) {
        String key = null;
        String hfield = null;
        if (null != keyExpression && keyExpression.trim().length() > 0) {
            try {
                key = this.scriptParser.getDefinedCacheKey(keyExpression, target, arguments, result, hasRetVal);
                if (null != hfieldExpression && hfieldExpression.trim().length() > 0) {
                    hfield = this.scriptParser.getDefinedCacheKey(hfieldExpression, target, arguments, result, hasRetVal);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            key = CacheUtil.getDefaultCacheKey(target.getClass().getName(), methodName, arguments);
        }
        if (null == key || key.trim().isEmpty()) {
            throw new IllegalArgumentException("cache key for " + target.getClass().getName() + "." + methodName + " is empty");
        }
        return new CacheKeyTO(this.config.getNamespace(), key, hfield);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Cache cache) {
        Object target = pjp.getTarget();
        String methodName = pjp.getMethod().getName();
        Object[] arguments = pjp.getArgs();
        String keyExpression = cache.key();
        String hfieldExpression = cache.hfield();
        return this.getCacheKey(target, methodName, arguments, keyExpression, hfieldExpression, null, false);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Cache cache, Object result) {
        Object target = pjp.getTarget();
        String methodName = pjp.getMethod().getName();
        Object[] arguments = pjp.getArgs();
        String keyExpression = cache.key();
        String hfieldExpression = cache.hfield();
        return this.getCacheKey(target, methodName, arguments, keyExpression, hfieldExpression, result, true);
    }

    private CacheKeyTO getCacheKey(CacheAopProxyChain pjp, Object[] arguments, ExCache exCache, Object result) {
        Object target = pjp.getTarget();
        String methodName = pjp.getMethod().getName();
        String keyExpression = exCache.key();
        if (null == keyExpression || keyExpression.trim().length() == 0) {
            return null;
        }
        String hfieldExpression = exCache.hfield();
        return this.getCacheKey(target, methodName, arguments, keyExpression, hfieldExpression, result, true);
    }

    public AutoLoadHandler getAutoLoadHandler() {
        return this.autoLoadHandler;
    }

    public AbstractScriptParser getScriptParser() {
        return this.scriptParser;
    }

    private void registerFunction(Map<String, String> funcs) {
        if (null == this.scriptParser) {
            return;
        }
        if (null == funcs || funcs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : funcs.entrySet()) {
            try {
                String name = entry.getKey();
                Class<?> cls = Class.forName(entry.getValue());
                Method method = cls.getDeclaredMethod(name, Object.class);
                this.scriptParser.addFunction(name, method);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ILock getLock() {
        return this.lock;
    }

    public void setLock(ILock lock) {
        this.lock = lock;
    }

    public void setCache(CacheKeyTO cacheKey, CacheWrapper<Object> result, Method method) throws CacheCenterConnectionException {
        this.cacheManager.setCache(cacheKey, result, method);
        if (null != this.changeListener) {
            this.changeListener.update(cacheKey, result);
        }
    }

    public Map<CacheKeyTO, CacheWrapper<Object>> mget(Method method, Type returnType, Set<CacheKeyTO> keySet) throws CacheCenterConnectionException {
        return this.cacheManager.mget(method, returnType, keySet);
    }

    public void mset(Method method, Collection<MSetParam> params) throws CacheCenterConnectionException {
        this.cacheManager.mset(method, params);
    }

    public CacheWrapper<Object> get(CacheKeyTO key, Method method) throws CacheCenterConnectionException {
        return this.cacheManager.get(key, method);
    }

    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == keys || keys.isEmpty()) {
            return;
        }
        this.cacheManager.delete(keys);
        if (null != this.changeListener) {
            this.changeListener.delete(keys);
        }
    }

    public ICloner getCloner() {
        return this.cloner;
    }

    public AutoLoadConfig getAutoLoadConfig() {
        return this.config;
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }
}

