/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache;

import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.annotation.CacheDeleteMagicKey;
import com.jarvis.cache.aop.DeleteCacheAopProxyChain;
import com.jarvis.cache.to.CacheKeyTO;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DeleteCacheMagicHandler {
    private final CacheHandler cacheHandler;
    private final DeleteCacheAopProxyChain jp;
    private final CacheDeleteMagicKey[] cacheDeleteKeys;
    private final Object[] arguments;
    private final Method method;
    private final Object retVal;
    private final Object target;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public DeleteCacheMagicHandler(CacheHandler cacheHandler, DeleteCacheAopProxyChain jp, CacheDeleteMagicKey[] cacheDeleteKeys, Object retVal) {
        this.cacheHandler = cacheHandler;
        this.jp = jp;
        this.cacheDeleteKeys = cacheDeleteKeys;
        this.arguments = jp.getArgs();
        this.method = jp.getMethod();
        this.retVal = retVal;
        this.target = jp.getTarget();
        this.methodName = jp.getMethod().getName();
        this.parameterTypes = this.method.getParameterTypes();
    }

    private void isMagic(CacheDeleteMagicKey cacheDeleteKey) throws Exception {
        Class<?> returnType;
        String key = cacheDeleteKey.value();
        if (null == key || key.length() == 0) {
            throw new Exception("value\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        int iterableArgIndex = cacheDeleteKey.iterableArgIndex();
        if (this.parameterTypes.length > 0 && iterableArgIndex >= 0) {
            if (iterableArgIndex >= this.parameterTypes.length) {
                throw new Exception("iterableArgIndex\u5fc5\u987b\u5c0f\u4e8e\u53c2\u6570\u957f\u5ea6\uff1a" + this.parameterTypes.length);
            }
            if (iterableArgIndex >= 0 && cacheDeleteKey.iterableReturnValue()) {
                throw new Exception("\u4e0d\u652f\u6301iterableArgIndex\u5927\u4e8e0\u4e14iterableReturnValue=true\u7684\u60c5\u51b5");
            }
            Class<?> tmp = this.parameterTypes[iterableArgIndex];
            if (!tmp.isArray() && !Collection.class.isAssignableFrom(tmp)) {
                throw new Exception("magic\u6a21\u5f0f\u4e0b\uff0c\u53c2\u6570" + iterableArgIndex + "\u5fc5\u987b\u662f\u6570\u7ec4\u6216Collection\u7684\u7c7b\u578b");
            }
        }
        if (cacheDeleteKey.iterableReturnValue() && !(returnType = this.method.getReturnType()).isArray() && !Collection.class.isAssignableFrom(returnType)) {
            throw new Exception("\u5f53iterableReturnValue=true\u65f6\uff0c\u8fd4\u56de\u503c\u5fc5\u987b\u662f\u6570\u7ec4\u6216Collection\u7684\u7c7b\u578b");
        }
    }

    public List<List<CacheKeyTO>> getCacheKeyForMagic() throws Exception {
        ArrayList<List<CacheKeyTO>> lists = new ArrayList<List<CacheKeyTO>>(this.cacheDeleteKeys.length);
        for (CacheDeleteMagicKey cacheDeleteKey : this.cacheDeleteKeys) {
            this.isMagic(cacheDeleteKey);
            String keyExpression = cacheDeleteKey.value();
            String hfieldExpression = cacheDeleteKey.hfield();
            if (this.parameterTypes.length == 0 || cacheDeleteKey.iterableArgIndex() < 0) {
                if (!cacheDeleteKey.iterableReturnValue()) continue;
                lists.add(this.splitReturnValueOnly(cacheDeleteKey, this.retVal, keyExpression, hfieldExpression));
                continue;
            }
            int iterableArgIndex = cacheDeleteKey.iterableArgIndex();
            if (iterableArgIndex >= 0 && !cacheDeleteKey.iterableReturnValue()) {
                lists.add(this.splitArgOnly(cacheDeleteKey, this.retVal, keyExpression, hfieldExpression));
                continue;
            }
            if (iterableArgIndex >= 0 && !cacheDeleteKey.iterableReturnValue()) continue;
        }
        return lists;
    }

    private List<CacheKeyTO> splitReturnValueOnly(CacheDeleteMagicKey cacheDeleteKey, Object retVal, String keyExpression, String hfieldExpression) throws Exception {
        ArrayList<CacheKeyTO> list;
        if (null == retVal) {
            return Collections.emptyList();
        }
        if (retVal.getClass().isArray()) {
            Object[] newValues = (Object[])retVal;
            list = new ArrayList<CacheKeyTO>(newValues.length);
            for (Object value : newValues) {
                if (!this.cacheHandler.getScriptParser().isCanDelete(cacheDeleteKey, this.arguments, value)) continue;
                list.add(this.cacheHandler.getCacheKey(this.target, this.methodName, this.arguments, keyExpression, hfieldExpression, value, true));
            }
        } else if (retVal instanceof Collection) {
            Collection newValues = (Collection)retVal;
            list = new ArrayList(newValues.size());
            for (Object value : newValues) {
                if (!this.cacheHandler.getScriptParser().isCanDelete(cacheDeleteKey, this.arguments, value)) continue;
                list.add(this.cacheHandler.getCacheKey(this.target, this.methodName, this.arguments, keyExpression, hfieldExpression, value, true));
            }
        } else {
            return Collections.emptyList();
        }
        return list;
    }

    private List<CacheKeyTO> splitArgOnly(CacheDeleteMagicKey cacheDeleteKey, Object retVal, String keyExpression, String hfieldExpression) throws Exception {
        int iterableArgIndex = cacheDeleteKey.iterableArgIndex();
        Object tmpArg = this.arguments[iterableArgIndex];
        ArrayList<CacheKeyTO> list = null;
        if (tmpArg instanceof Collection) {
            Collection iterableCollectionArg = (Collection)tmpArg;
            list = new ArrayList<CacheKeyTO>(iterableCollectionArg.size());
            for (Object arg : iterableCollectionArg) {
                Optional<CacheKeyTO> tmp = this.getKey(arg, cacheDeleteKey, retVal, keyExpression, hfieldExpression);
                if (!tmp.isPresent()) continue;
                list.add(tmp.get());
            }
        } else if (tmpArg.getClass().isArray()) {
            Object[] iterableArrayArg = (Object[])tmpArg;
            list = new ArrayList(iterableArrayArg.length);
            for (Object arg : iterableArrayArg) {
                Optional<CacheKeyTO> tmp = this.getKey(arg, cacheDeleteKey, retVal, keyExpression, hfieldExpression);
                if (!tmp.isPresent()) continue;
                list.add(tmp.get());
            }
        } else {
            return Collections.emptyList();
        }
        return list;
    }

    private Optional<CacheKeyTO> getKey(Object arg, CacheDeleteMagicKey cacheDeleteKey, Object retVal, String keyExpression, String hfieldExpression) throws Exception {
        Object[] tmpArgs = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            tmpArgs[i] = i == cacheDeleteKey.iterableArgIndex() ? arg : this.arguments[i];
        }
        if (!this.cacheHandler.getScriptParser().isCanDelete(cacheDeleteKey, tmpArgs, retVal)) {
            return Optional.empty();
        }
        return Optional.of(this.cacheHandler.getCacheKey(this.target, this.methodName, tmpArgs, keyExpression, hfieldExpression, retVal, true));
    }
}

