/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.compress;

import com.jarvis.cache.compress.ICompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class CommonsCompressor
implements ICompressor {
    private static final int BUFFER = 1024;
    private static final CompressorStreamFactory FACTORY = new CompressorStreamFactory();
    private String name;

    public CommonsCompressor(String name) {
        this.name = name;
    }

    @Override
    public byte[] compress(ByteArrayInputStream bais) throws Exception {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressorOutputStream cos = FACTORY.createCompressorOutputStream(this.name, (OutputStream)baos);
        byte[] buf = new byte[1024];
        while ((len = bais.read(buf, 0, 1024)) != -1) {
            cos.write(buf, 0, len);
        }
        cos.flush();
        cos.close();
        byte[] output = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return output;
    }

    @Override
    public byte[] decompress(ByteArrayInputStream bais) throws Exception {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressorInputStream cis = FACTORY.createCompressorInputStream(this.name, (InputStream)bais);
        byte[] buf = new byte[1024];
        while ((len = cis.read(buf, 0, 1024)) != -1) {
            baos.write(buf, 0, len);
        }
        cis.close();
        byte[] output = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return output;
    }
}

