/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.lock;

import com.jarvis.cache.lock.AbstractRedisLock;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class ShardedJedisLock
extends AbstractRedisLock {
    private ShardedJedisPool shardedJedisPool;

    public ShardedJedisLock(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool = shardedJedisPool;
    }

    private void returnResource(ShardedJedis shardedJedis) {
        shardedJedis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setnx(String key, String val, int expire) {
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.shardedJedisPool.getResource();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            boolean bl = "OK".equalsIgnoreCase(jedis.set(key, val, "NX", "EX", expire));
            return bl;
        }
        finally {
            this.returnResource(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void del(String key) {
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.shardedJedisPool.getResource();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            jedis.del(key);
        }
        finally {
            this.returnResource(shardedJedis);
        }
    }
}

