/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.redis.IRedis;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.StringSerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisCacheManager
implements ICacheManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisCacheManager.class);
    public static final StringSerializer KEY_SERIALIZER = new StringSerializer();
    protected int hashExpire = -1;
    protected final ISerializer<Object> serializer;

    public AbstractRedisCacheManager(ISerializer<Object> serializer) {
        this.serializer = serializer;
    }

    protected abstract IRedis getRedis();

    @Override
    public void setCache(CacheKeyTO cacheKeyTO, CacheWrapper<Object> result, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return;
        }
        try (IRedis redis = this.getRedis();){
            String hfield = cacheKeyTO.getHfield();
            byte[] key = KEY_SERIALIZER.serialize(cacheKey);
            byte[] val = this.serializer.serialize(result);
            if (null == hfield || hfield.isEmpty()) {
                int expire = result.getExpire();
                if (expire == 0) {
                    redis.set(key, val);
                } else if (expire > 0) {
                    redis.setex(key, expire, val);
                }
            } else {
                int hExpire;
                byte[] field = KEY_SERIALIZER.serialize(hfield);
                int n = hExpire = this.hashExpire < 0 ? result.getExpire() : this.hashExpire;
                if (hExpire == 0) {
                    redis.hset(key, field, val);
                } else if (hExpire > 0) {
                    redis.hset(key, field, val, hExpire);
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void mset(Method method, Collection<MSetParam> params) {
        if (null == params || params.isEmpty()) {
            return;
        }
        try (IRedis redis = this.getRedis();){
            redis.mset(params);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public CacheWrapper<Object> get(CacheKeyTO cacheKeyTO, Method method) throws CacheCenterConnectionException {
        if (null == cacheKeyTO) {
            return null;
        }
        String cacheKey = cacheKeyTO.getCacheKey();
        if (null == cacheKey || cacheKey.isEmpty()) {
            return null;
        }
        CacheWrapper res = null;
        Type returnType = null;
        try (IRedis redis = this.getRedis();){
            String hfield = cacheKeyTO.getHfield();
            byte[] val = null == hfield || hfield.isEmpty() ? redis.get(KEY_SERIALIZER.serialize(cacheKey)) : redis.hget(KEY_SERIALIZER.serialize(cacheKey), KEY_SERIALIZER.serialize(hfield));
            if (null != method) {
                returnType = method.getGenericReturnType();
            }
            res = (CacheWrapper)this.serializer.deserialize(val, returnType);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CacheKeyTO, CacheWrapper<Object>> mget(Method method, Type returnType, Set<CacheKeyTO> keys) {
        if (null == keys) return null;
        if (keys.isEmpty()) {
            return null;
        }
        try (IRedis redis = this.getRedis();){
            Map<CacheKeyTO, CacheWrapper<Object>> map = redis.mget(returnType, keys);
            return map;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Map<CacheKeyTO, CacheWrapper<Object>> deserialize(Set<CacheKeyTO> keys, Collection<Object> values, Type returnType) throws Exception {
        if (null == values || values.isEmpty()) {
            return null;
        }
        HashMap<CacheKeyTO, CacheWrapper<Object>> res = new HashMap<CacheKeyTO, CacheWrapper<Object>>(keys.size());
        Iterator<CacheKeyTO> keysIt = keys.iterator();
        for (Object value : values) {
            CacheKeyTO cacheKeyTO = keysIt.next();
            if (null == value) continue;
            if (!(value instanceof byte[])) {
                log.warn("the data from redis is not byte[] but " + value.getClass().getName());
                continue;
            }
            CacheWrapper tmp = (CacheWrapper)this.serializer.deserialize((byte[])value, returnType);
            if (null == tmp) continue;
            res.put(cacheKeyTO, tmp);
        }
        return res;
    }

    @Override
    public void delete(Set<CacheKeyTO> keys) throws CacheCenterConnectionException {
        if (null == keys || keys.isEmpty()) {
            return;
        }
        try (IRedis redis = this.getRedis();){
            redis.delete(keys);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public int getHashExpire() {
        return this.hashExpire;
    }

    public void setHashExpire(int hashExpire) {
        if (hashExpire < 0) {
            return;
        }
        this.hashExpire = hashExpire;
    }

    public ISerializer<Object> getSerializer() {
        return this.serializer;
    }
}

