/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.redis.IRedis;
import com.jarvis.cache.redis.JedisClusterPipeline;
import com.jarvis.cache.redis.JedisUtil;
import com.jarvis.cache.redis.RetryableJedisClusterPipeline;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class JedisClusterCacheManager
extends AbstractRedisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(JedisClusterCacheManager.class);
    private final JedisClusterClient redis;

    public JedisClusterCacheManager(JedisCluster jedisCluster, ISerializer<Object> serializer) {
        super(serializer);
        this.redis = new JedisClusterClient(jedisCluster, this);
    }

    @Override
    protected IRedis getRedis() {
        return this.redis;
    }

    public static class JedisClusterClient
    implements IRedis {
        private final JedisCluster jedisCluster;
        private final AbstractRedisCacheManager cacheManager;

        public JedisClusterClient(JedisCluster jedisCluster, AbstractRedisCacheManager cacheManager) {
            this.jedisCluster = jedisCluster;
            this.cacheManager = cacheManager;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void set(byte[] key, byte[] value) {
            this.jedisCluster.set(key, value);
        }

        @Override
        public void setex(byte[] key, int seconds, byte[] value) {
            this.jedisCluster.setex(key, seconds, value);
        }

        @Override
        public void hset(byte[] key, byte[] field, byte[] value) {
            this.jedisCluster.hset(key, field, value);
        }

        @Override
        public void hset(final byte[] key, final byte[] field, final byte[] value, final int seconds) {
            RetryableJedisClusterPipeline retryableJedisClusterPipeline = new RetryableJedisClusterPipeline(this.jedisCluster){

                @Override
                public void execute(JedisClusterPipeline pipeline) {
                    pipeline.hset(key, field, value);
                    pipeline.expire(key, seconds);
                }
            };
            try {
                retryableJedisClusterPipeline.sync();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void mset(final Collection<MSetParam> params) {
            RetryableJedisClusterPipeline retryableJedisClusterPipeline = new RetryableJedisClusterPipeline(this.jedisCluster){

                @Override
                public void execute(JedisClusterPipeline pipeline) throws Exception {
                    JedisUtil.executeMSet(pipeline, cacheManager, params);
                }
            };
            try {
                retryableJedisClusterPipeline.sync();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public byte[] get(byte[] key) {
            return this.jedisCluster.get(key);
        }

        @Override
        public byte[] hget(byte[] key, byte[] field) {
            return this.jedisCluster.hget(key, field);
        }

        @Override
        public Map<CacheKeyTO, CacheWrapper<Object>> mget(Type returnType, final Set<CacheKeyTO> keys) throws Exception {
            RetryableJedisClusterPipeline retryableJedisClusterPipeline = new RetryableJedisClusterPipeline(this.jedisCluster){

                @Override
                public void execute(JedisClusterPipeline pipeline) {
                    JedisUtil.executeMGet(pipeline, keys);
                }
            };
            return this.cacheManager.deserialize(keys, retryableJedisClusterPipeline.syncAndReturnAll(), returnType);
        }

        @Override
        public void delete(final Set<CacheKeyTO> keys) {
            RetryableJedisClusterPipeline retryableJedisClusterPipeline = new RetryableJedisClusterPipeline(this.jedisCluster){

                @Override
                public void execute(JedisClusterPipeline pipeline) {
                    JedisUtil.executeDelete(pipeline, keys);
                }
            };
            try {
                retryableJedisClusterPipeline.sync();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

