/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.PipelineBase;

public class JedisUtil {
    private static final Logger log = LoggerFactory.getLogger(JedisUtil.class);

    public static void executeMSet(PipelineBase pipeline, AbstractRedisCacheManager manager, Collection<MSetParam> params) throws Exception {
        for (MSetParam param : params) {
            CacheKeyTO cacheKeyTO;
            String cacheKey;
            if (null == param || null == (cacheKey = (cacheKeyTO = param.getCacheKey()).getCacheKey()) || cacheKey.isEmpty()) continue;
            CacheWrapper<Object> result = param.getResult();
            String hfield = cacheKeyTO.getHfield();
            byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
            byte[] val = manager.getSerializer().serialize(result);
            if (null == hfield || hfield.isEmpty()) {
                int expire = result.getExpire();
                if (expire == 0) {
                    pipeline.set(key, val);
                    continue;
                }
                if (expire <= 0) continue;
                pipeline.setex(key, expire, val);
                continue;
            }
            int hExpire = manager.getHashExpire() < 0 ? result.getExpire() : manager.getHashExpire();
            pipeline.hset(key, AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield), val);
            if (hExpire <= 0) continue;
            pipeline.expire(key, hExpire);
        }
    }

    public static void executeMGet(PipelineBase pipeline, Set<CacheKeyTO> keys) {
        for (CacheKeyTO cacheKeyTO : keys) {
            String cacheKey = cacheKeyTO.getCacheKey();
            if (null == cacheKey || cacheKey.isEmpty()) continue;
            String hfield = cacheKeyTO.getHfield();
            byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
            if (null == hfield || hfield.isEmpty()) {
                pipeline.get(key);
                continue;
            }
            pipeline.hget(key, AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield));
        }
    }

    public static void executeDelete(PipelineBase pipeline, Set<CacheKeyTO> keys) {
        for (CacheKeyTO cacheKeyTO : keys) {
            String cacheKey = cacheKeyTO.getCacheKey();
            if (null == cacheKey || cacheKey.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("delete cache {}", (Object)cacheKey);
            }
            String hfield = cacheKeyTO.getHfield();
            byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
            if (null == hfield || hfield.isEmpty()) {
                pipeline.del(key);
                continue;
            }
            pipeline.hdel(key, (byte[][])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield)});
        }
    }
}

