/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import io.lettuce.core.AbstractRedisAsyncCommands;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceRedisUtil {
    private static final Logger log = LoggerFactory.getLogger(LettuceRedisUtil.class);

    public static void executeMSet(AbstractRedisAsyncCommands<byte[], byte[]> pipeline, AbstractRedisCacheManager manager, Collection<MSetParam> params) throws Exception {
        for (MSetParam param : params) {
            CacheKeyTO cacheKeyTO;
            String cacheKey;
            if (null == param || null == (cacheKey = (cacheKeyTO = param.getCacheKey()).getCacheKey()) || cacheKey.isEmpty()) continue;
            CacheWrapper<Object> result = param.getResult();
            String hfield = cacheKeyTO.getHfield();
            byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
            byte[] val = manager.getSerializer().serialize(result);
            if (null == hfield || hfield.isEmpty()) {
                int expire = result.getExpire();
                if (expire == 0) {
                    pipeline.set((Object)key, (Object)val);
                    continue;
                }
                if (expire <= 0) continue;
                pipeline.setex((Object)key, (long)expire, (Object)val);
                continue;
            }
            int hExpire = manager.getHashExpire() < 0 ? result.getExpire() : manager.getHashExpire();
            pipeline.hset((Object)key, (Object)AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield), (Object)val);
            if (hExpire <= 0) continue;
            pipeline.expire((Object)key, (long)hExpire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<CacheKeyTO, CacheWrapper<Object>> executeMGet(StatefulConnection<byte[], byte[]> connection, AbstractRedisAsyncCommands<byte[], byte[]> asyncCommands, AbstractRedisCacheManager cacheManager, Type returnType, Set<CacheKeyTO> keys) {
        RedisFuture[] futures = new RedisFuture[keys.size()];
        try {
            connection.setAutoFlushCommands(false);
            int i = 0;
            for (CacheKeyTO cacheKeyTO : keys) {
                String cacheKey = cacheKeyTO.getCacheKey();
                if (null == cacheKey || cacheKey.isEmpty()) continue;
                String hfield = cacheKeyTO.getHfield();
                byte[] key = AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey);
                futures[i] = null == hfield || hfield.isEmpty() ? asyncCommands.get((Object)key) : asyncCommands.hget((Object)key, (Object)AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield));
                ++i;
            }
        }
        finally {
            connection.flushCommands();
        }
        HashMap<CacheKeyTO, CacheWrapper<Object>> res = new HashMap<CacheKeyTO, CacheWrapper<Object>>(keys.size());
        int i = 0;
        for (CacheKeyTO cacheKeyTO : keys) {
            RedisFuture future = futures[i];
            try {
                byte[] data = (byte[])future.get();
                if (null == data || data.length == 0) continue;
                CacheWrapper value = (CacheWrapper)cacheManager.getSerializer().deserialize(data, returnType);
                if (null != value) {
                    res.put(cacheKeyTO, value);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return res;
    }
}

