/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.redis.JedisClusterPipeline;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisCluster;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisSlotBasedConnectionHandler;
import redis.clients.jedis.exceptions.JedisMovedDataException;

public abstract class RetryableJedisClusterPipeline {
    private static final Logger log = LoggerFactory.getLogger(RetryableJedisClusterPipeline.class);
    private static final Field FIELD_CONNECTION_HANDLER = RetryableJedisClusterPipeline.getField(BinaryJedisCluster.class, "connectionHandler");
    private static final Field FIELD_CACHE = RetryableJedisClusterPipeline.getField(JedisClusterConnectionHandler.class, "cache");
    private final JedisSlotBasedConnectionHandler connectionHandler;
    private final JedisClusterInfoCache clusterInfoCache;
    private int maxAttempts = 1;

    public RetryableJedisClusterPipeline(JedisCluster jedisCluster) {
        this.connectionHandler = (JedisSlotBasedConnectionHandler)RetryableJedisClusterPipeline.getValue(jedisCluster, FIELD_CONNECTION_HANDLER);
        this.clusterInfoCache = (JedisClusterInfoCache)RetryableJedisClusterPipeline.getValue(this.connectionHandler, FIELD_CACHE);
    }

    public abstract void execute(JedisClusterPipeline var1) throws Exception;

    public void sync() throws Exception {
        try {
            JedisClusterPipeline pipeline = new JedisClusterPipeline(this.clusterInfoCache);
            this.execute(pipeline);
            pipeline.sync();
        }
        catch (JedisMovedDataException jre) {
            this.connectionHandler.renewSlotCache();
            if (this.maxAttempts > 0) {
                --this.maxAttempts;
                this.sync();
                return;
            }
            throw jre;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public List<Object> syncAndReturnAll() throws Exception {
        try {
            JedisClusterPipeline pipeline = new JedisClusterPipeline(this.clusterInfoCache);
            this.execute(pipeline);
            return pipeline.syncAndReturnAll();
        }
        catch (JedisMovedDataException jre) {
            this.connectionHandler.renewSlotCache();
            if (this.maxAttempts > 0) {
                --this.maxAttempts;
                return this.syncAndReturnAll();
            }
            throw jre;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private static Field getField(Class<?> cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("cannot find or access field '" + fieldName + "' from " + cls.getName(), e);
        }
    }

    private static <T> T getValue(Object obj, Field field) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("get value fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

