/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.script;

import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.script.AbstractScriptParser;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import ognl.OgnlContext;

public class OgnlParser
extends AbstractScriptParser {
    private final ConcurrentHashMap<String, Object> EXPRESSION_CACHE = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> funcs = new ConcurrentHashMap(8);

    @Override
    public void addFunction(String name, Method method) {
        this.funcs.put(name, method.getDeclaringClass());
    }

    @Override
    public <T> T getElValue(String exp, Object target, Object[] arguments, Object retVal, boolean hasRetVal, Class<T> valueType) throws Exception {
        if (valueType.equals(String.class) && exp.indexOf("#") == -1 && exp.indexOf("@") == -1 && exp.indexOf("'") == -1) {
            return (T)exp;
        }
        Object object = this.EXPRESSION_CACHE.get(exp);
        if (null == object) {
            String className = CacheUtil.class.getName();
            String exp2 = exp.replaceAll("@@hash\\(", "@" + className + "@getUniqueHashStr(");
            exp2 = exp2.replaceAll("@@empty\\(", "@" + className + "@isEmpty(");
            for (Map.Entry<String, Class<?>> entry : this.funcs.entrySet()) {
                className = entry.getValue().getName();
                exp2 = exp2.replaceAll("@@" + entry.getKey() + "\\(", "@" + className + "@" + entry.getKey() + "(");
            }
            object = Ognl.parseExpression((String)exp2);
            this.EXPRESSION_CACHE.put(exp, object);
        }
        HashMap<String, Object> values = new HashMap<String, Object>(2);
        values.put("target", target);
        values.put("args", arguments);
        if (hasRetVal) {
            values.put("retVal", retVal);
        }
        OgnlContext context = new OgnlContext(values);
        context.setRoot((Object)arguments);
        Object res = Ognl.getValue((Object)object, (Map)context, (Object)context.getRoot(), valueType);
        return (T)res;
    }
}

