/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.script;

import com.jarvis.cache.CacheUtil;
import com.jarvis.cache.script.AbstractScriptParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringELParser
extends AbstractScriptParser {
    private static final String POUND = "#";
    private static final String apostrophe = "'";
    private final ExpressionParser parser = new SpelExpressionParser();
    private final ConcurrentHashMap<String, Expression> expCache = new ConcurrentHashMap();
    private static Method hash = null;
    private static Method empty = null;
    private final ConcurrentHashMap<String, Method> funcs = new ConcurrentHashMap(8);

    @Override
    public void addFunction(String name, Method method) {
        this.funcs.put(name, method);
    }

    @Override
    public <T> T getElValue(String keySpEL, Object target, Object[] arguments, Object retVal, boolean hasRetVal, Class<T> valueType) throws Exception {
        Expression expression;
        if (valueType.equals(String.class) && keySpEL.indexOf(POUND) == -1 && keySpEL.indexOf(apostrophe) == -1) {
            return (T)keySpEL;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.registerFunction("hash", hash);
        context.registerFunction("empty", empty);
        for (Map.Entry<String, Method> entry : this.funcs.entrySet()) {
            context.registerFunction(entry.getKey(), entry.getValue());
        }
        context.setVariable("target", target);
        context.setVariable("args", (Object)arguments);
        if (hasRetVal) {
            context.setVariable("retVal", retVal);
        }
        if (null == (expression = this.expCache.get(keySpEL))) {
            expression = this.parser.parseExpression(keySpEL);
            this.expCache.put(keySpEL, expression);
        }
        return (T)expression.getValue((EvaluationContext)context, valueType);
    }

    static {
        try {
            hash = CacheUtil.class.getDeclaredMethod("getUniqueHashStr", Object.class);
            empty = CacheUtil.class.getDeclaredMethod("isEmpty", Object.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

