/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.jarvis.cache.serializer.kryo.KryoClassRegistration;
import com.jarvis.cache.serializer.kryo.KryoContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DefaultKryoContext
implements KryoContext {
    private static final int DEFAULT_BUFFER_SIZE = 102400;
    private KryoPool pool;
    private List<KryoClassRegistration> registrations = new ArrayList<KryoClassRegistration>();

    public static KryoContext newKryoContextFactory(KryoClassRegistration registration) {
        DefaultKryoContext kryoContext = new DefaultKryoContext();
        kryoContext.addKryoClassRegistration(registration);
        return kryoContext;
    }

    private DefaultKryoContext() {
        this.pool = new KryoPool.Builder(() -> {
            Kryo kryo = new Kryo();
            this.registrations.forEach(reg -> reg.register(kryo));
            return kryo;
        }).softReferences().build();
    }

    @Override
    public byte[] serialize(Object obj) {
        return this.serialize(obj, 102400);
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] serialize(Object obj, int bufferSize) {
        Kryo kryo = this.pool.borrow();
        try {
            try (Output output = new Output((OutputStream)new ByteArrayOutputStream(), bufferSize);){
                kryo.writeClassAndObject(output, obj);
                byte[] byArray = output.toBytes();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(kryo);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object deserialize(byte[] serialized) {
        Kryo kryo = this.pool.borrow();
        try {
            try (Input input = new Input((InputStream)new ByteArrayInputStream(serialized));){
                Object o;
                Object object = o = kryo.readClassAndObject(input);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.release(kryo);
        }
    }

    @Override
    public void addKryoClassRegistration(KryoClassRegistration registration) {
        if (null != registration) {
            this.registrations.add(registration);
        }
    }
}

