/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.to;

import com.jarvis.cache.type.AutoLoadQueueSortType;
import java.util.Map;

public class AutoLoadConfig {
    private String namespace;
    private Integer threadCnt = 10;
    private int maxElement = 20000;
    private boolean printSlowLog = true;
    private int slowLoadTime = 500;
    private AutoLoadQueueSortType sortType = AutoLoadQueueSortType.NONE;
    private boolean checkFromCacheBeforeLoad = false;
    private int autoLoadPeriod = 50;
    private int loadUseTimeForAutoLoad1 = 10;
    private int loadUseTimeForAutoLoad2 = 200;
    private int refreshThreadPoolSize = 2;
    private int refreshThreadPoolMaxSize = 20;
    private int refreshThreadPoolkeepAliveTime = 20;
    private int refreshQueueCapacity = 2000;
    private Map<String, String> functions;
    private int loadDataTryCnt = 1;
    private int processingMapSize = 512;
    private boolean dataLoaderPooled = true;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getThreadCnt() {
        return this.threadCnt;
    }

    public void setThreadCnt(int threadCnt) {
        if (threadCnt <= 0) {
            return;
        }
        this.threadCnt = threadCnt;
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public void setMaxElement(int maxElement) {
        if (maxElement <= 0) {
            return;
        }
        this.maxElement = maxElement;
    }

    public AutoLoadQueueSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(Integer sortType) {
        this.sortType = AutoLoadQueueSortType.getById(sortType);
    }

    public boolean isPrintSlowLog() {
        return this.printSlowLog;
    }

    public void setPrintSlowLog(boolean printSlowLog) {
        this.printSlowLog = printSlowLog;
    }

    public int getSlowLoadTime() {
        return this.slowLoadTime;
    }

    public void setSlowLoadTime(int slowLoadTime) {
        if (slowLoadTime < 0) {
            return;
        }
        this.slowLoadTime = slowLoadTime;
    }

    public boolean isCheckFromCacheBeforeLoad() {
        return this.checkFromCacheBeforeLoad;
    }

    public void setCheckFromCacheBeforeLoad(boolean checkFromCacheBeforeLoad) {
        this.checkFromCacheBeforeLoad = checkFromCacheBeforeLoad;
    }

    public int getAutoLoadPeriod() {
        return this.autoLoadPeriod;
    }

    public void setAutoLoadPeriod(int autoLoadPeriod) {
        int defaultPeriod = 5;
        if (autoLoadPeriod < defaultPeriod) {
            return;
        }
        this.autoLoadPeriod = autoLoadPeriod;
    }

    public void setFunctions(Map<String, String> funcs) {
        if (null == funcs || funcs.isEmpty()) {
            return;
        }
        this.functions = funcs;
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public int getRefreshThreadPoolSize() {
        return this.refreshThreadPoolSize;
    }

    public void setRefreshThreadPoolSize(int refreshThreadPoolSize) {
        if (refreshThreadPoolSize > 1) {
            this.refreshThreadPoolSize = refreshThreadPoolSize;
        }
    }

    public int getRefreshThreadPoolMaxSize() {
        return this.refreshThreadPoolMaxSize;
    }

    public void setRefreshThreadPoolMaxSize(int refreshThreadPoolMaxSize) {
        if (refreshThreadPoolMaxSize > 1) {
            this.refreshThreadPoolMaxSize = refreshThreadPoolMaxSize;
        }
    }

    public int getRefreshThreadPoolkeepAliveTime() {
        return this.refreshThreadPoolkeepAliveTime;
    }

    public void setRefreshThreadPoolkeepAliveTime(int refreshThreadPoolkeepAliveTime) {
        if (refreshThreadPoolkeepAliveTime > 1) {
            this.refreshThreadPoolkeepAliveTime = refreshThreadPoolkeepAliveTime;
        }
    }

    public int getRefreshQueueCapacity() {
        return this.refreshQueueCapacity;
    }

    public void setRefreshQueueCapacity(int refreshQueueCapacity) {
        if (refreshQueueCapacity > 1) {
            this.refreshQueueCapacity = refreshQueueCapacity;
        }
    }

    public int getLoadDataTryCnt() {
        return this.loadDataTryCnt;
    }

    public void setLoadDataTryCnt(int loadDataTryCnt) {
        int minCnt = 0;
        int maxCnt = 5;
        if (loadDataTryCnt >= minCnt && loadDataTryCnt < maxCnt) {
            this.loadDataTryCnt = loadDataTryCnt;
        }
    }

    public int getProcessingMapSize() {
        return this.processingMapSize;
    }

    public void setProcessingMapSize(int processingMapSize) {
        int minSize = 64;
        this.processingMapSize = processingMapSize < minSize ? minSize : processingMapSize;
    }

    public int getLoadUseTimeForAutoLoad1() {
        return this.loadUseTimeForAutoLoad1;
    }

    public int getLoadUseTimeForAutoLoad2() {
        return this.loadUseTimeForAutoLoad2;
    }

    public boolean isDataLoaderPooled() {
        return this.dataLoaderPooled;
    }

    public void setLoadUseTimeForAutoLoad1(int loadUseTimeForAutoLoad1) {
        this.loadUseTimeForAutoLoad1 = loadUseTimeForAutoLoad1;
    }

    public void setLoadUseTimeForAutoLoad2(int loadUseTimeForAutoLoad2) {
        this.loadUseTimeForAutoLoad2 = loadUseTimeForAutoLoad2;
    }

    public void setDataLoaderPooled(boolean dataLoaderPooled) {
        this.dataLoaderPooled = dataLoaderPooled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoLoadConfig)) {
            return false;
        }
        AutoLoadConfig other = (AutoLoadConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.getThreadCnt() != other.getThreadCnt()) {
            return false;
        }
        if (this.getMaxElement() != other.getMaxElement()) {
            return false;
        }
        if (this.isPrintSlowLog() != other.isPrintSlowLog()) {
            return false;
        }
        if (this.getSlowLoadTime() != other.getSlowLoadTime()) {
            return false;
        }
        AutoLoadQueueSortType this$sortType = this.getSortType();
        AutoLoadQueueSortType other$sortType = other.getSortType();
        if (this$sortType == null ? other$sortType != null : !((Object)((Object)this$sortType)).equals((Object)other$sortType)) {
            return false;
        }
        if (this.isCheckFromCacheBeforeLoad() != other.isCheckFromCacheBeforeLoad()) {
            return false;
        }
        if (this.getAutoLoadPeriod() != other.getAutoLoadPeriod()) {
            return false;
        }
        if (this.getLoadUseTimeForAutoLoad1() != other.getLoadUseTimeForAutoLoad1()) {
            return false;
        }
        if (this.getLoadUseTimeForAutoLoad2() != other.getLoadUseTimeForAutoLoad2()) {
            return false;
        }
        if (this.getRefreshThreadPoolSize() != other.getRefreshThreadPoolSize()) {
            return false;
        }
        if (this.getRefreshThreadPoolMaxSize() != other.getRefreshThreadPoolMaxSize()) {
            return false;
        }
        if (this.getRefreshThreadPoolkeepAliveTime() != other.getRefreshThreadPoolkeepAliveTime()) {
            return false;
        }
        if (this.getRefreshQueueCapacity() != other.getRefreshQueueCapacity()) {
            return false;
        }
        Map<String, String> this$functions = this.getFunctions();
        Map<String, String> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        if (this.getLoadDataTryCnt() != other.getLoadDataTryCnt()) {
            return false;
        }
        if (this.getProcessingMapSize() != other.getProcessingMapSize()) {
            return false;
        }
        return this.isDataLoaderPooled() == other.isDataLoaderPooled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoLoadConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + this.getThreadCnt();
        result = result * 59 + this.getMaxElement();
        result = result * 59 + (this.isPrintSlowLog() ? 79 : 97);
        result = result * 59 + this.getSlowLoadTime();
        AutoLoadQueueSortType $sortType = this.getSortType();
        result = result * 59 + ($sortType == null ? 43 : ((Object)((Object)$sortType)).hashCode());
        result = result * 59 + (this.isCheckFromCacheBeforeLoad() ? 79 : 97);
        result = result * 59 + this.getAutoLoadPeriod();
        result = result * 59 + this.getLoadUseTimeForAutoLoad1();
        result = result * 59 + this.getLoadUseTimeForAutoLoad2();
        result = result * 59 + this.getRefreshThreadPoolSize();
        result = result * 59 + this.getRefreshThreadPoolMaxSize();
        result = result * 59 + this.getRefreshThreadPoolkeepAliveTime();
        result = result * 59 + this.getRefreshQueueCapacity();
        Map<String, String> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        result = result * 59 + this.getLoadDataTryCnt();
        result = result * 59 + this.getProcessingMapSize();
        result = result * 59 + (this.isDataLoaderPooled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AutoLoadConfig(namespace=" + this.getNamespace() + ", threadCnt=" + this.getThreadCnt() + ", maxElement=" + this.getMaxElement() + ", printSlowLog=" + this.isPrintSlowLog() + ", slowLoadTime=" + this.getSlowLoadTime() + ", sortType=" + (Object)((Object)this.getSortType()) + ", checkFromCacheBeforeLoad=" + this.isCheckFromCacheBeforeLoad() + ", autoLoadPeriod=" + this.getAutoLoadPeriod() + ", loadUseTimeForAutoLoad1=" + this.getLoadUseTimeForAutoLoad1() + ", loadUseTimeForAutoLoad2=" + this.getLoadUseTimeForAutoLoad2() + ", refreshThreadPoolSize=" + this.getRefreshThreadPoolSize() + ", refreshThreadPoolMaxSize=" + this.getRefreshThreadPoolMaxSize() + ", refreshThreadPoolkeepAliveTime=" + this.getRefreshThreadPoolkeepAliveTime() + ", refreshQueueCapacity=" + this.getRefreshQueueCapacity() + ", functions=" + this.getFunctions() + ", loadDataTryCnt=" + this.getLoadDataTryCnt() + ", processingMapSize=" + this.getProcessingMapSize() + ", dataLoaderPooled=" + this.isDataLoaderPooled() + ")";
    }
}

