/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.lib.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanUtil {
    private static final ConcurrentHashMap<Class, Field[]> FIELDS_CAHCE = new ConcurrentHashMap();

    public static boolean isPrimitive(Object obj) {
        boolean rv = obj.getClass().isPrimitive() || obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Byte || obj instanceof Character || obj instanceof Boolean || obj instanceof Short || obj instanceof Float || obj instanceof Double || obj instanceof BigDecimal || obj instanceof BigInteger;
        return rv;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> cl = obj.getClass();
        if (BeanUtil.isPrimitive(obj)) {
            return String.valueOf(obj);
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        if (obj instanceof Date) {
            return String.valueOf(((Date)obj).getTime());
        }
        if (obj instanceof Calendar) {
            return String.valueOf(((Calendar)obj).getTime().getTime());
        }
        if (cl.isArray()) {
            String r = "[";
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    r = r + ",";
                }
                Object val = Array.get(obj, i);
                r = r + BeanUtil.toString(val);
            }
            return r + "]";
        }
        if (obj instanceof Collection) {
            Collection tempCol = (Collection)obj;
            Iterator it = tempCol.iterator();
            String r = "[";
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    r = r + ",";
                }
                Object val = it.next();
                r = r + BeanUtil.toString(val);
                ++i;
            }
            return r + "]";
        }
        if (obj instanceof Map) {
            Map tempMap = (Map)obj;
            String r = "{";
            Iterator it = tempMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                r = r + BeanUtil.toString(key);
                r = r + "=";
                Object val = entry.getValue();
                r = r + BeanUtil.toString(val);
                if (!it.hasNext()) continue;
                r = r + ",";
            }
            return r + "}";
        }
        if (obj instanceof Class) {
            Class tmpCls = (Class)obj;
            return tmpCls.getName();
        }
        String r = cl.getName();
        do {
            AccessibleObject[] fields;
            if (null == (fields = FIELDS_CAHCE.get(cl))) {
                fields = cl.getDeclaredFields();
                if (null != fields) {
                    AccessibleObject.setAccessible(fields, true);
                }
                FIELDS_CAHCE.put(cl, (Field[])fields);
            }
            if (null == fields || fields.length == 0) {
                cl = cl.getSuperclass();
                continue;
            }
            r = r + "[";
            for (AccessibleObject f : fields) {
                if (Modifier.isStatic(((Field)f).getModifiers()) || ((Field)f).isSynthetic() || ((Field)f).getName().indexOf("this$") != -1) continue;
                r = r + ((Field)f).getName() + "=";
                try {
                    Object val = ((Field)f).get(obj);
                    r = r + BeanUtil.toString(val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                r = r + ",";
            }
            String comma = ",";
            if (r.endsWith(comma)) {
                r = r.substring(0, r.length() - 1);
            }
            r = r + "]";
            cl = cl.getSuperclass();
        } while (cl != null);
        return r;
    }
}

