/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL;

import com.github.quintans.ezSQL.DbJdbcSession;
import com.github.quintans.ezSQL.common.api.Updatable;
import com.github.quintans.ezSQL.common.type.MyDate;
import com.github.quintans.ezSQL.common.type.MyDateTime;
import com.github.quintans.ezSQL.common.type.MyTime;
import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Relation;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.dml.DmlBase;
import com.github.quintans.ezSQL.dml.Insert;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.toolkit.io.BinStore;
import com.github.quintans.ezSQL.toolkit.io.TextStore;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.JdbcSession;
import com.github.quintans.jdbc.SimpleJdbc;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDb {
    private static Logger LOGGER = Logger.getLogger(AbstractDb.class);
    private Driver driver;
    private JdbcSession jdbcSession = new DbJdbcSession(this);
    private Connection connection;

    protected abstract Connection connection();

    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.connection();
            this.driver.prepareConnection(this.connection);
        }
        return this.connection;
    }

    public <T> T loadAssociation(Object bean, Association association) {
        SequencedCollection<Object> value;
        String targetAlias = association.getAlias();
        PropertyDescriptor targetBp = Misc.getPropertyDescriptor(bean.getClass(), targetAlias);
        try {
            Set changed;
            value = targetBp.getReadMethod().invoke(bean, new Object[0]);
            if (value != null) {
                return (T)value;
            }
            if (bean instanceof Updatable && (changed = ((Updatable)bean).changed()) != null && changed.contains(targetBp.getName())) {
                return null;
            }
            Class<?> klass = targetBp.getPropertyType();
            Relation[] relations = association.getRelations();
            ArrayList<Condition> restrictions = new ArrayList<Condition>();
            for (Relation relation : relations) {
                String fkAlias = relation.getFrom().getColumn().getAlias();
                PropertyDescriptor pd = Misc.getPropertyDescriptor(bean.getClass(), fkAlias);
                value = pd.getReadMethod().invoke(bean, new Object[0]);
                restrictions.add(relation.getTo().getColumn().is(Definition.raw(value)));
            }
            DmlBase query = this.query(association.getTableTo()).all().where(restrictions);
            if (Collection.class.isAssignableFrom(klass)) {
                Class<?> genKlass = Misc.genericClass(targetBp.getWriteMethod().getGenericParameterTypes()[0]);
                value = ((Query)query).list(genKlass);
                if (Set.class.isAssignableFrom(klass)) {
                    value = new LinkedHashSet(value);
                } else if (List.class.isAssignableFrom(klass)) {
                    value = new ArrayList((Collection)value);
                }
            } else {
                value = ((Query)query).select(klass);
            }
            targetBp.getWriteMethod().invoke(bean, value);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to retrive association " + association + " for " + bean, (Throwable)ex);
        }
        return (T)value;
    }

    public Query query(Table table) {
        return new Query(this, table);
    }

    public Query query(Query query) {
        return new Query(query);
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public JdbcSession getJdbcSession() {
        return this.jdbcSession;
    }

    public Long fetchAutoNumberBefore(Column<? extends Number> column) {
        return this.fetchAutoNumber(column, false);
    }

    public Long fetchCurrentAutoNumberAfter(Column<? extends Number> column) {
        return this.fetchAutoNumber(column, true);
    }

    public Long fetchAutoNumber(Column<? extends Number> column, boolean after) {
        String sql = after ? this.driver.getCurrentAutoNumberQuery(column) : this.driver.getAutoNumberQuery(column);
        long now = 0L;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SQL: " + sql));
            now = System.nanoTime();
        }
        SimpleJdbc jdbc = new SimpleJdbc(this.jdbcSession);
        Long id = jdbc.queryForLong(sql, new LinkedHashMap());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("executed in: " + (double)(System.nanoTime() - now) / 1000000.0 + "ms"));
        }
        return id;
    }

    public Insert insert(Table table) {
        return new Insert(this, table);
    }

    public Update update(Table table) {
        return new Update(this, table);
    }

    public Delete delete(Table table) {
        return new Delete(this, table);
    }

    public Map<String, Object> transformParameters(Map<String, Object> parameters) {
        LinkedHashMap<String, Object> pars = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object val = entry.getValue();
            val = this.transformParameter(val);
            pars.put(entry.getKey(), val);
        }
        return pars;
    }

    public Object[] transformParameters(Object ... parameters) {
        if (parameters == null) {
            return null;
        }
        Object[] vals = new Object[parameters.length];
        int i = 0;
        for (Object parameter : parameters) {
            vals[i++] = this.transformParameter(parameter);
        }
        return vals;
    }

    public Object transformParameter(Object parameter) {
        Object val = parameter;
        if (val instanceof NullSql) {
            val = this.driver.fromNull((NullSql)((Object)val));
        } else if (val instanceof Boolean) {
            val = this.driver.fromBoolean((Boolean)val);
        } else if (val instanceof Byte) {
            val = this.driver.fromTiny((Byte)val);
        } else if (val instanceof Short) {
            val = this.driver.fromShort((Short)val);
        } else if (val instanceof Integer) {
            val = this.driver.fromInteger((Integer)val);
        } else if (val instanceof Long) {
            val = this.driver.fromLong((Long)val);
        } else if (val instanceof Double) {
            val = this.driver.fromDecimal((Double)val);
        } else if (val instanceof BigDecimal) {
            val = this.driver.fromBigDecimal((BigDecimal)val);
        } else if (val instanceof String) {
            val = this.driver.fromString((String)val);
        } else if (val instanceof MyTime) {
            val = this.driver.fromTime((Date)val);
        } else if (val instanceof MyDate) {
            val = this.driver.fromDate((Date)val);
        } else if (val instanceof MyDateTime) {
            val = this.driver.fromDateTime((Date)val);
        } else if (val instanceof Date) {
            val = this.driver.fromTimestamp((Date)val);
        } else if (val instanceof TextStore) {
            TextStore txt = (TextStore)val;
            try {
                val = this.driver.fromText(txt.getInputStream(), (int)txt.getSize());
            }
            catch (IOException e) {
                throw new PersistenceException("Unable to get input stream from TextCache!", (Throwable)e);
            }
        } else if (val instanceof BinStore) {
            BinStore bin = (BinStore)val;
            try {
                val = this.driver.fromBin(bin.getInputStream(), (int)bin.getSize());
            }
            catch (IOException e) {
                throw new PersistenceException("Unable to get input stream from ByteCache!", (Throwable)e);
            }
        } else if (val instanceof char[]) {
            String txt = new String((char[])val);
            try {
                InputStream is = IOUtils.toInputStream((String)txt, (String)"UTF-8");
                val = this.driver.fromText(is, txt.length());
            }
            catch (IOException e) {
                throw new PersistenceException("Unable to get input stream from String!", (Throwable)e);
            }
        } else if (val instanceof byte[]) {
            byte[] bin = (byte[])val;
            val = this.driver.fromBin(new ByteArrayInputStream(bin), bin.length);
        } else {
            val = this.driver.fromUnknown(val);
        }
        return val;
    }
}

