/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.db;

import com.github.quintans.ezSQL.common.type.MyDate;
import com.github.quintans.ezSQL.common.type.MyTime;
import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.ColGroup;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Discriminator;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.PreDeleteTrigger;
import com.github.quintans.ezSQL.db.PreInsertTrigger;
import com.github.quintans.ezSQL.db.PreUpdateTrigger;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.toolkit.io.BinStore;
import com.github.quintans.ezSQL.toolkit.io.TextStore;
import com.github.quintans.ezSQL.toolkit.utils.Strings;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Table {
    private Map<String, Column<?>> columnsMap = new LinkedHashMap();
    private Map<String, Association> associationMap = null;
    protected String name = null;
    protected String alias = null;
    protected Set<Column<?>> columns = new LinkedHashSet();
    protected Column<?> singleKey;
    protected Set<Column<?>> keys = new LinkedHashSet();
    protected Column<?> version = null;
    protected Column<?> deletion = null;
    protected List<Discriminator> discriminators;
    protected PreInsertTrigger preInsertTrigger;
    protected PreUpdateTrigger preUpdateTrigger;
    protected PreDeleteTrigger preDeleteTrigger;

    public Table(String table) {
        if (table == null || "".equals(table)) {
            throw new NullPointerException("Null for table is not allowed.");
        }
        this.name = table;
        this.alias = Strings.toCamelCase(table);
    }

    public Table copy() {
        Table table = new Table(this.name);
        table.alias = this.alias;
        table.columnsMap = new LinkedHashMap(this.columnsMap);
        if (this.associationMap != null) {
            table.associationMap = new LinkedHashMap<String, Association>(this.associationMap);
        }
        table.columns = new LinkedHashSet(this.columns);
        table.singleKey = this.singleKey;
        table.keys = new LinkedHashSet(this.keys);
        table.version = this.version;
        table.deletion = this.deletion;
        if (table.discriminators != null) {
            table.discriminators = new ArrayList<Discriminator>(this.discriminators);
        }
        table.preInsertTrigger = this.preInsertTrigger;
        table.preUpdateTrigger = this.preUpdateTrigger;
        table.preDeleteTrigger = this.preDeleteTrigger;
        return table;
    }

    public PreInsertTrigger getPreInsertTrigger() {
        return this.preInsertTrigger;
    }

    public void setPreInsertTrigger(PreInsertTrigger preInsertTrigger) {
        this.preInsertTrigger = preInsertTrigger;
    }

    public PreUpdateTrigger getPreUpdateTrigger() {
        return this.preUpdateTrigger;
    }

    public void setPreUpdateTrigger(PreUpdateTrigger preUpdateTrigger) {
        this.preUpdateTrigger = preUpdateTrigger;
    }

    public PreDeleteTrigger getPreDeleteTrigger() {
        return this.preDeleteTrigger;
    }

    public void setPreDeleteTrigger(PreDeleteTrigger preDeleteTrigger) {
        this.preDeleteTrigger = preDeleteTrigger;
    }

    public String getAlias() {
        return this.alias;
    }

    public Table AS(String alias) {
        this.alias = alias;
        return this;
    }

    public Column<Boolean> BOOLEAN(String name) {
        return this.COLUMN(name, NullSql.BOOLEAN);
    }

    public Column<Character> CHAR(String name) {
        return this.COLUMN(name, NullSql.CHAR);
    }

    public <T> Column<T> NUMBERED(String name) {
        return this.COLUMN(name, NullSql.INTEGER);
    }

    public <T> Column<T> NAMED(String name) {
        return this.COLUMN(name, NullSql.VARCHAR);
    }

    public Column<String> VARCHAR(String name) {
        return this.COLUMN(name, NullSql.VARCHAR);
    }

    public Column<Integer> TINY(String name) {
        return this.COLUMN(name, NullSql.TINY);
    }

    public Column<Integer> SMALL(String name) {
        return this.COLUMN(name, NullSql.SMALL);
    }

    public Column<Integer> INTEGER(String name) {
        return this.COLUMN(name, NullSql.INTEGER);
    }

    public Column<Long> BIGINT(String name) {
        return this.COLUMN(name, NullSql.BIGINT);
    }

    public Column<Double> DECIMAL(String name) {
        return this.COLUMN(name, NullSql.DECIMAL);
    }

    public Column<MyTime> TIME(String name) {
        return this.COLUMN(name, NullSql.TIME);
    }

    public Column<MyDate> DATE(String name) {
        return this.COLUMN(name, NullSql.DATE);
    }

    public Column<Date> DATETIME(String name) {
        return this.COLUMN(name, NullSql.DATETIME);
    }

    public Column<Date> TIMESTAMP(String name) {
        return this.COLUMN(name, NullSql.TIMESTAMP);
    }

    public <T> Column<T> CLOB(String name) {
        return this.COLUMN(name, NullSql.CLOB);
    }

    public Column<byte[]> BLOB(String name) {
        return this.COLUMN(name, NullSql.BLOB);
    }

    public Column<BinStore> BIN(String name) {
        return this.COLUMN(name, NullSql.BLOB);
    }

    public Column<TextStore> TEXT(String name) {
        return this.COLUMN(name, NullSql.CLOB);
    }

    public <T> Column<T> COLUMN(String name, NullSql type) {
        Column col = new Column(name, type);
        this.addColumn(col);
        return col;
    }

    private void addColumn(Column<?> col) {
        col.table = this;
        if (!this.columns.contains(col)) {
            this.columns.add(col);
            if (this.columnsMap.get(col.getAlias()) != null) {
                throw new PersistenceException(String.format("The alias '%s' for the column '%s' is not unique!", col.getAlias(), col.toString()));
            }
            this.columnsMap.put(col.getAlias(), col);
        }
    }

    public <T> Table WITH(Column<T> column, T ... values) {
        if (this.discriminators == null) {
            this.discriminators = new ArrayList<Discriminator>();
        }
        for (T value : values) {
            this.discriminators.add(new Discriminator(column, value));
        }
        return this;
    }

    public ColGroup ASSOCIATE(Column<?> ... from) {
        for (Column<?> source : from) {
            if (this.equals(source.getTable())) continue;
            throw new PersistenceException(source.toString() + " does not belong to " + this.toString());
        }
        return new ColGroup(from);
    }

    public String getName() {
        return this.name;
    }

    public Set<Column<?>> getColumns() {
        return this.columns;
    }

    public List<Column<?>> getBasicColumns() {
        ArrayList list = new ArrayList();
        for (Column<?> column : this.columns) {
            if (column.isKey() || column.isVersion() || column.isDeletion()) continue;
            list.add(column);
        }
        return list;
    }

    public String toString() {
        return this.name;
    }

    public Column<?> getSingleKeyColumn() {
        return this.singleKey;
    }

    public Set<Column<?>> getKeyColumns() {
        return this.keys;
    }

    protected void addKey(Column<?> col) {
        this.keys.add(col);
        this.singleKey = this.keys.size() == 1 ? col : null;
    }

    public Column<?> getVersionColumn() {
        return this.version;
    }

    protected void setVersionColumn(Column<?> column) {
        this.version = column;
    }

    public Column<?> getDeletionColumn() {
        return this.deletion;
    }

    protected void setDeletionColumn(Column<?> column) {
        this.deletion = column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Table) {
            Table table = (Table)obj;
            return this.alias.equals(table.alias) && this.name.equals(table.name);
        }
        return false;
    }

    public Association addAssociation(Association fk) {
        return this.addAssociation(fk.getAlias(), fk);
    }

    public Association addAssociation(String name, Association fk) {
        if (this.associationMap == null) {
            this.associationMap = new LinkedHashMap<String, Association>();
        } else if (this.associationMap.containsKey(name)) {
            throw new PersistenceException(String.format("A associa\u00e7\u00e3o %s j\u00e1 se encontra mapeada para a tabela %s com o valor %s", fk.toString(), this.getAlias(), this.associationMap.get(fk.getAlias()).toString()));
        }
        this.associationMap.put(name, fk);
        return fk;
    }

    public Collection<Association> getAssociations() {
        if (this.associationMap != null) {
            return this.associationMap.values();
        }
        return null;
    }

    public List<Discriminator> getDiscriminators() {
        return this.discriminators;
    }

    public List<Condition> getConditions() {
        if (this.discriminators != null) {
            ArrayList<Condition> conditions = new ArrayList<Condition>(this.discriminators.size());
            for (Discriminator disc : this.discriminators) {
                conditions.add(disc.getCondition());
            }
            return conditions;
        }
        return null;
    }
}

